/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.ShutdownHookUtils;

class ShutdownHookCallbacksThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownHookCallbacksThread.class);
    static final ShutdownHookCallbacksThread INSTANCE = new ShutdownHookCallbacksThread();

    ShutdownHookCallbacksThread() {
        this.setName(this.getClass().getSimpleName());
    }

    @Override
    public void run() {
        this.executeShutdownHookCallbacks();
        ShutdownHookUtils.clearShutdownHookCallbacks();
    }

    private void executeShutdownHookCallbacks() {
        for (Runnable callback : ShutdownHookUtils.shutdownHookCallbacks) {
            if (logger.isTraceEnabled()) {
                logger.trace("The ShutdownHook Callback is about to run : {}", callback);
            }
            callback.run();
        }
    }
}

