/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.Utils;
import io.microsphere.util.VersionUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class StackTraceUtils
implements Utils {
    private static final Class<?> TYPE;
    private static final Logger logger;
    private static final boolean IS_JDK_9_OR_LATER;
    public static final String STACK_WALKER_CLASS_NAME = "java.lang.StackWalker";
    public static final String STACK_WALKER_OPTION_CLASS_NAME = "java.lang.StackWalker$Option";
    public static final String STACK_WALKER_STACK_FRAME_CLASS_NAME = "java.lang.StackWalker$StackFrame";
    @Nullable
    public static final Class<?> STACK_WALKER_CLASS;
    @Nullable
    public static final Class<?> STACK_WALKER_OPTION_CLASS;
    @Nullable
    public static final Class<?> STACK_WALKER_STACK_FRAME_CLASS;
    static final String RETAIN_CLASS_REFERENCE_OPTION_NAME = "RETAIN_CLASS_REFERENCE";
    static final String SHOW_REFLECT_FRAMES_OPTION_NAME = "SHOW_REFLECT_FRAMES";
    static final String SHOW_HIDDEN_FRAMES_OPTION_NAME = "SHOW_HIDDEN_FRAMES";
    static final String GET_INSTANCE_METHOD_NAME = "getInstance";
    static final String WALK_METHOD_NAME = "walk";
    static final String GET_CLASS_NAME_METHOD_NAME = "getClassName";
    static final Method WALK_METHOD;
    static final Method GET_CLASS_NAME_METHOD;
    private static final Object stackWalkerInstance;
    static boolean stackWalkerSupportedForTesting;
    private static final Function<Stream<?>, Object> getClassNamesFunction;
    private static final int stackTraceElementInvocationFrame;
    private static final int stackWalkerInvocationFrame;

    @Nonnull
    public static StackTraceElement[] getStackTrace() {
        return Thread.currentThread().getStackTrace();
    }

    public static String getCallerClassName() {
        if (stackWalkerInstance == null || !stackWalkerSupportedForTesting) {
            return StackTraceUtils.getCallerClassNameInGeneralJVM(stackTraceElementInvocationFrame + 3);
        }
        List<String> callerClassNames = StackTraceUtils.getCallerClassNames();
        String className = callerClassNames.get(stackWalkerInvocationFrame);
        return className;
    }

    static List<String> getCallerClassNames() {
        return (List)MethodUtils.invokeMethod(stackWalkerInstance, WALK_METHOD, getClassNamesFunction);
    }

    private static List<String> getCallerClassNames(Stream<?> stackFrames) {
        return stackFrames.limit(5L).map(StackTraceUtils::getClassName).collect(Collectors.toList());
    }

    private static String getClassName(Object stackFrame) {
        return (String)MethodUtils.invokeMethod(stackFrame, GET_CLASS_NAME_METHOD, new Object[0]);
    }

    static String getCallerClassNameInGeneralJVM() {
        return StackTraceUtils.getCallerClassNameInGeneralJVM(stackTraceElementInvocationFrame + 3);
    }

    static String getCallerClassNameInGeneralJVM(int invocationFrame) throws IndexOutOfBoundsException {
        StackTraceElement[] elements = StackTraceUtils.getStackTrace();
        if (invocationFrame < elements.length) {
            StackTraceElement targetStackTraceElement = elements[invocationFrame];
            return targetStackTraceElement.getClassName();
        }
        return null;
    }

    private StackTraceUtils() {
    }

    static {
        StackTraceElement[] stackTraceElements;
        TYPE = StackTraceUtils.class;
        logger = LoggerFactory.getLogger(TYPE);
        IS_JDK_9_OR_LATER = VersionUtils.CURRENT_JAVA_VERSION.ge(VersionUtils.JAVA_VERSION_9);
        getClassNamesFunction = StackTraceUtils::getCallerClassNames;
        Class<?> stackWalkerClass = null;
        Class<?> stackWalkerOptionClass = null;
        Class<?> stackWalkerStackFrameClass = null;
        Method walkMethod = null;
        Method getClassNameMethod = null;
        Object stackWalker = null;
        if (IS_JDK_9_OR_LATER) {
            stackWalkerClass = ClassLoaderUtils.resolveClass(STACK_WALKER_CLASS_NAME);
            stackWalkerOptionClass = ClassLoaderUtils.resolveClass(STACK_WALKER_OPTION_CLASS_NAME);
            stackWalkerStackFrameClass = ClassLoaderUtils.resolveClass(STACK_WALKER_STACK_FRAME_CLASS_NAME);
            walkMethod = MethodUtils.findMethod(stackWalkerClass, WALK_METHOD_NAME, Function.class);
            walkMethod.setAccessible(true);
            getClassNameMethod = MethodUtils.findMethod(stackWalkerStackFrameClass, GET_CLASS_NAME_METHOD_NAME);
            getClassNameMethod.setAccessible(true);
            stackWalker = MethodUtils.invokeStaticMethod(stackWalkerClass, GET_INSTANCE_METHOD_NAME, new Object[0]);
            stackWalkerSupportedForTesting = true;
        }
        STACK_WALKER_CLASS = stackWalkerClass;
        STACK_WALKER_OPTION_CLASS = stackWalkerOptionClass;
        STACK_WALKER_STACK_FRAME_CLASS = stackWalkerStackFrameClass;
        WALK_METHOD = walkMethod;
        GET_CLASS_NAME_METHOD = getClassNameMethod;
        stackWalkerInstance = stackWalker;
        int invocationFrame = 0;
        if (IS_JDK_9_OR_LATER) {
            List<String> stackFrameClassNames = StackTraceUtils.getCallerClassNames();
            for (String stackFrameClassName : stackFrameClassNames) {
                if (TYPE.getName().equals(stackFrameClassName)) break;
                ++invocationFrame;
            }
        }
        stackWalkerInvocationFrame = invocationFrame + 2;
        int invocationFrame2 = 0;
        for (StackTraceElement stackTraceElement : stackTraceElements = StackTraceUtils.getStackTrace()) {
            String className = stackTraceElement.getClassName();
            if (TYPE.getName().equals(className)) break;
            ++invocationFrame2;
        }
        stackTraceElementInvocationFrame = invocationFrame2;
    }
}

