/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nullable;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.CharSequenceUtils;
import io.microsphere.util.Utils;
import java.util.StringTokenizer;

public abstract class StringUtils
implements Utils {
    public static final String EMPTY = "";
    public static final String EMPTY_STRING = "";
    @Immutable
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtils.EMPTY_STRING_ARRAY;
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isBlank(String value) {
        int length = CharSequenceUtils.length(value);
        if (length < 1) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String value) {
        return !StringUtils.isBlank(value);
    }

    public static String[] split(String value, char delimiter) {
        return StringUtils.split(value, String.valueOf(delimiter));
    }

    public static String[] split(String value, String delimiter) {
        if (CharSequenceUtils.isEmpty(value) || CharSequenceUtils.isEmpty(delimiter)) {
            return EMPTY_STRING_ARRAY;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(value, delimiter);
        return (String[])ArrayUtils.asArray(stringTokenizer, String.class);
    }

    public static boolean contains(String value, CharSequence part) {
        if (value != null && part != null) {
            return value == part ? true : value.contains(part);
        }
        return false;
    }

    public static boolean startsWith(String value, String part) {
        if (value != null && part != null) {
            return value == part ? true : value.startsWith(part);
        }
        return false;
    }

    public static boolean endsWith(String value, String part) {
        if (value != null && part != null) {
            return value == part ? true : value.endsWith(part);
        }
        return false;
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (CharSequenceUtils.isEmpty(text) || CharSequenceUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String substringBetween(String str, String tag) {
        return StringUtils.substringBetween(str, tag, tag);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String substringBefore(String str, String separator) {
        if (CharSequenceUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (CharSequenceUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String str, String separator) {
        if (CharSequenceUtils.isEmpty(str) || CharSequenceUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (CharSequenceUtils.isEmpty(str)) {
            return str;
        }
        if (CharSequenceUtils.isEmpty(separator)) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static boolean isNumeric(String str) {
        int sz = CharSequenceUtils.length(str);
        if (sz == 0) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsWhitespace(@Nullable String str) {
        return CharSequenceUtils.containsWhitespace(str);
    }

    public static String trimWhitespace(String str) {
        return StringUtils.trimWhitespace(str, true, true);
    }

    public static String trimLeadingWhitespace(String str) {
        return StringUtils.trimWhitespace(str, true, false);
    }

    public static String trimTrailingWhitespace(String str) {
        return StringUtils.trimWhitespace(str, false, true);
    }

    public static String trimAllWhitespace(String str) {
        return CharSequenceUtils.isEmpty(str) ? str : CharSequenceUtils.trimAllWhitespace(str).toString();
    }

    public static String capitalize(String str) {
        return StringUtils.changeFirstCharacter(str, true);
    }

    public static String uncapitalize(String str) {
        return StringUtils.changeFirstCharacter(str, false);
    }

    static String changeFirstCharacter(String str, boolean capitalize) {
        char updatedChar;
        int len = CharSequenceUtils.length(str);
        if (len < 1) {
            return str;
        }
        char baseChar = str.charAt(0);
        if (baseChar == (updatedChar = capitalize ? Character.toUpperCase(baseChar) : Character.toLowerCase(baseChar))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = updatedChar;
        return new String(chars);
    }

    static String trimWhitespace(String str, boolean includeLeading, boolean includeTrailing) {
        int beginIndex;
        int len = CharSequenceUtils.length(str);
        if (len < 1) {
            return str;
        }
        int endIndex = len - 1;
        if (includeLeading) {
            for (beginIndex = 0; beginIndex <= endIndex && Character.isWhitespace(str.charAt(beginIndex)); ++beginIndex) {
            }
        }
        if (includeTrailing) {
            while (endIndex > beginIndex && Character.isWhitespace(str.charAt(endIndex))) {
                --endIndex;
            }
        }
        return str.substring(beginIndex, endIndex + 1);
    }

    private StringUtils() {
    }
}

