/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nullable;
import io.microsphere.collection.MapUtils;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.StringUtils;
import io.microsphere.util.Utils;
import java.util.Map;
import java.util.Properties;

public abstract class SystemUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);
    public static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    public static final String JAVA_CLASS_PATH_PROPERTY_KEY = "java.class.path";
    public static final String USER_NAME_PROPERTY_KEY = "user.name";
    @Deprecated
    public static final String JAVA_EXT_DIRS_PROPERTY_KEY = "java.ext.dirs";
    public static final String JAVA_VENDOR_PROPERTY_KEY = "java.vendor";
    public static final String JAVA_SPECIFICATION_VERSION_PROPERTY_KEY = "java.specification.version";
    public static final String LINE_SEPARATOR_PROPERTY_KEY = "line.separator";
    public static final String JAVA_CLASS_VERSION_PROPERTY_KEY = "java.class.version";
    public static final String JAVA_SPECIFICATION_NAME_PROPERTY_KEY = "java.specification.name";
    public static final String JAVA_VENDOR_URL_PROPERTY_KEY = "java.vendor.url";
    public static final String JAVA_VM_VERSION_PROPERTY_KEY = "java.vm.version";
    public static final String OS_NAME_PROPERTY_KEY = "os.name";
    public static final String OS_ARCH_PROPERTY_KEY = "os.arch";
    public static final String JAVA_HOME_PROPERTY_KEY = "java.home";
    public static final String OS_VERSION_PROPERTY_KEY = "os.version";
    public static final String JAVA_COMPILER_PROPERTY_KEY = "java.compiler";
    public static final String JAVA_VERSION_PROPERTY_KEY = "java.version";
    public static final String JAVA_VM_SPECIFICATION_VERSION_PROPERTY_KEY = "java.vm.specification.version";
    public static final String USER_DIR_PROPERTY_KEY = "user.dir";
    public static final String JAVA_SPECIFICATION_VENDOR_PROPERTY_KEY = "java.specification.vendor";
    public static final String JAVA_VM_SPECIFICATION_NAME_PROPERTY_KEY = "java.vm.specification.name";
    public static final String JAVA_VM_VENDOR_PROPERTY_KEY = "java.vm.vendor";
    public static final String FILE_SEPARATOR_PROPERTY_KEY = "file.separator";
    public static final String PATH_SEPARATOR_PROPERTY_KEY = "path.separator";
    public static final String JAVA_LIBRARY_PATH_PROPERTY_KEY = "java.library.path";
    public static final String USER_HOME_PROPERTY_KEY = "user.home";
    public static final String JAVA_VM_NAME_PROPERTY_KEY = "java.vm.name";
    public static final String JAVA_VM_SPECIFICATION_VENDOR_PROPERTY_KEY = "java.vm.specification.vendor";
    public static final String JAVA_IO_TMPDIR_PROPERTY_KEY = "java.io.tmpdir";
    public static final String FILE_ENCODING_PROPERTY_KEY = "file.encoding";
    public static final String NATIVE_ENCODING_PROPERTY_KEY = "native.encoding";
    public static final String JAVA_CLASS_PATH = SystemUtils.getSystemProperty("java.class.path");
    public static final String USER_NAME = SystemUtils.getSystemProperty("user.name");
    public static final String JAVA_EXT_DIRS = SystemUtils.getSystemProperty("java.ext.dirs");
    public static final String JAVA_VENDOR = SystemUtils.getSystemProperty("java.vendor");
    public static final String JAVA_SPECIFICATION_VERSION = SystemUtils.getSystemProperty("java.specification.version");
    public static final String JAVA_CLASS_VERSION = SystemUtils.getSystemProperty("java.class.version");
    public static final String JAVA_SPECIFICATION_NAME = SystemUtils.getSystemProperty("java.specification.name");
    public static final String JAVA_VENDOR_URL = SystemUtils.getSystemProperty("java.vendor.url");
    public static final String JAVA_VM_VERSION = SystemUtils.getSystemProperty("java.vm.version");
    public static final String OS_NAME = SystemUtils.getSystemProperty("os.name");
    public static final String OS_ARCH = SystemUtils.getSystemProperty("os.arch");
    public static final String JAVA_HOME = SystemUtils.getSystemProperty("java.home");
    public static final String OS_VERSION = SystemUtils.getSystemProperty("os.version");
    public static final String JAVA_COMPILER = SystemUtils.getSystemProperty("java.compiler");
    public static final String JAVA_VERSION = SystemUtils.getSystemProperty("java.version");
    public static final String JAVA_VM_SPECIFICATION_VERSION = SystemUtils.getSystemProperty("java.vm.specification.version");
    public static final String USER_DIR = SystemUtils.getSystemProperty("user.dir");
    public static final String JAVA_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty("java.specification.vendor");
    public static final String JAVA_VM_SPECIFICATION_NAME = SystemUtils.getSystemProperty("java.vm.specification.name");
    public static final String JAVA_VM_VENDOR = SystemUtils.getSystemProperty("java.vm.vendor");
    public static final String JAVA_LIBRARY_PATH = SystemUtils.getSystemProperty("java.library.path");
    public static final String USER_HOME = SystemUtils.getSystemProperty("user.home");
    public static final String JAVA_VM_NAME = SystemUtils.getSystemProperty("java.vm.name");
    public static final String JAVA_VM_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty("java.vm.specification.vendor");
    public static final String JAVA_IO_TMPDIR = SystemUtils.getSystemProperty("java.io.tmpdir");
    public static final String FILE_ENCODING = SystemUtils.getSystemProperty("file.encoding", "UTF-8");
    public static final String NATIVE_ENCODING = SystemUtils.getSystemProperty("native.encoding");
    public static final boolean IS_OS_WINDOWS = StringUtils.startsWith(OS_NAME, "Windows");
    public static final boolean IS_JAVA_8 = SystemUtils.matchesJavaVersion("1.8");
    public static final boolean IS_JAVA_9 = SystemUtils.matchesJavaVersion("9");
    public static final boolean IS_JAVA_10 = SystemUtils.matchesJavaVersion("10");
    public static final boolean IS_JAVA_11 = SystemUtils.matchesJavaVersion("11");
    public static final boolean IS_JAVA_12 = SystemUtils.matchesJavaVersion("12");
    public static final boolean IS_JAVA_13 = SystemUtils.matchesJavaVersion("13");
    public static final boolean IS_JAVA_14 = SystemUtils.matchesJavaVersion("14");
    public static final boolean IS_JAVA_15 = SystemUtils.matchesJavaVersion("15");
    public static final boolean IS_JAVA_16 = SystemUtils.matchesJavaVersion("16");
    public static final boolean IS_JAVA_17 = SystemUtils.matchesJavaVersion("17");
    public static final boolean IS_JAVA_18 = SystemUtils.matchesJavaVersion("18");
    public static final boolean IS_JAVA_19 = SystemUtils.matchesJavaVersion("19");
    public static final boolean IS_JAVA_20 = SystemUtils.matchesJavaVersion("20");
    public static final boolean IS_JAVA_21 = SystemUtils.matchesJavaVersion("21");
    public static final boolean IS_JAVA_22 = SystemUtils.matchesJavaVersion("22");
    public static final boolean IS_JAVA_23 = SystemUtils.matchesJavaVersion("23");
    public static final boolean IS_JAVA_24 = SystemUtils.matchesJavaVersion("24");
    public static final boolean IS_LTS_JAVA_VERSION = IS_JAVA_8 || IS_JAVA_11 || IS_JAVA_17 || IS_JAVA_21;
    private static Map<String, String> systemPropertiesCopy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySystemProperties() {
        Properties properties = System.getProperties();
        Class<SystemUtils> clazz = SystemUtils.class;
        synchronized (SystemUtils.class) {
            Map<String, String> copy = systemPropertiesCopy;
            if (copy == null) {
                systemPropertiesCopy = copy = MapUtils.newFixedHashMap(properties.size());
            } else {
                copy.clear();
            }
            copy.putAll(properties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (logger.isTraceEnabled()) {
                logger.trace("The JDK System Properties has been copied : {}", properties);
            }
            return;
        }
    }

    @Nullable
    public static String getSystemProperty(String key) {
        return SystemUtils.getSystemProperty(key, null);
    }

    @Nullable
    public static String getSystemProperty(String key, String defaultValue) {
        String value = SystemUtils.getSystemPropertyFromCopy(key);
        return value == null ? System.getProperty(key, defaultValue) : value;
    }

    protected static void resetSystemPropertiesCopy() {
        if (logger.isTraceEnabled()) {
            logger.trace("The copy of JDK System Properties has been reset!");
        }
        systemPropertiesCopy = null;
    }

    protected static String getSystemPropertyFromCopy(String key) {
        return systemPropertiesCopy == null ? null : systemPropertiesCopy.get(key);
    }

    private static boolean matchesJavaVersion(String versionPrefix) {
        return StringUtils.startsWith(JAVA_SPECIFICATION_VERSION, versionPrefix);
    }

    private SystemUtils() {
    }
}

