/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util.jar;

import io.microsphere.annotation.Immutable;
import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.ListUtils;
import io.microsphere.filter.JarEntryFilter;
import io.microsphere.io.IOUtils;
import io.microsphere.net.URLUtils;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class JarUtils
implements Utils {
    public static final String MANIFEST_RESOURCE_PATH = "META-INF/MANIFEST.MF";

    @Nullable
    public static JarFile toJarFile(URL jarURL) throws IOException {
        JarFile jarFile = null;
        String jarAbsolutePath = JarUtils.resolveJarAbsolutePath(jarURL);
        if (jarAbsolutePath == null) {
            return null;
        }
        jarFile = new JarFile(jarAbsolutePath);
        return jarFile;
    }

    protected static void assertJarURLProtocol(URL jarURL) throws NullPointerException, IllegalArgumentException {
        String protocol = jarURL.getProtocol();
        if (!"jar".equals(protocol) && !"file".equals(protocol)) {
            String message = FormatUtils.format("the protocol['{}'] of 'jarURL' is unsupported, except '{}' and '{}' ", protocol, "jar", "file");
            throw new IllegalArgumentException(message);
        }
    }

    @Nullable
    public static String resolveRelativePath(URL jarURL) throws NullPointerException, IllegalArgumentException {
        JarUtils.assertJarURLProtocol(jarURL);
        String form = jarURL.toExternalForm();
        String relativePath = StringUtils.substringAfter(form, "!/");
        relativePath = URLUtils.normalizePath(relativePath);
        return URLUtils.decode(relativePath);
    }

    @Nullable
    public static String resolveJarAbsolutePath(URL jarURL) throws NullPointerException, IllegalArgumentException {
        JarUtils.assertJarURLProtocol(jarURL);
        File archiveFile = URLUtils.resolveArchiveFile(jarURL);
        return archiveFile == null ? null : archiveFile.getAbsolutePath();
    }

    @Nonnull
    @Immutable
    public static List<JarEntry> filter(JarFile jarFile, JarEntryFilter jarEntryFilter) {
        if (jarFile == null) {
            return Collections.emptyList();
        }
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        List<JarEntry> jarEntriesList = ListUtils.ofList(jarEntries);
        return JarUtils.doFilter(jarEntriesList, jarEntryFilter);
    }

    @Nonnull
    @Immutable
    protected static List<JarEntry> doFilter(Iterable<JarEntry> jarEntries, JarEntryFilter jarEntryFilter) {
        LinkedList<JarEntry> jarEntriesList = new LinkedList<JarEntry>();
        for (JarEntry jarEntry : jarEntries) {
            if (jarEntryFilter != null && !jarEntryFilter.accept(jarEntry)) continue;
            jarEntriesList.add(jarEntry);
        }
        return Collections.unmodifiableList(jarEntriesList);
    }

    @Nullable
    public static JarEntry findJarEntry(URL jarURL) throws IOException {
        JarFile jarFile = JarUtils.toJarFile(jarURL);
        String relativePath = JarUtils.resolveRelativePath(jarURL);
        JarEntry jarEntry = jarFile.getJarEntry(relativePath);
        return jarEntry;
    }

    public static void extract(File jarSourceFile, File targetDirectory) throws IOException {
        JarUtils.extract(jarSourceFile, targetDirectory, null);
    }

    public static void extract(File jarSourceFile, File targetDirectory, JarEntryFilter jarEntryFilter) throws IOException {
        JarFile jarFile = new JarFile(jarSourceFile);
        JarUtils.extract(jarFile, targetDirectory, jarEntryFilter);
    }

    public static void extract(JarFile jarFile, File targetDirectory, JarEntryFilter jarEntryFilter) throws IOException {
        List<JarEntry> jarEntriesList = JarUtils.filter(jarFile, jarEntryFilter);
        JarUtils.doExtract(jarFile, jarEntriesList, targetDirectory);
    }

    public static void extract(URL jarResourceURL, File targetDirectory, JarEntryFilter jarEntryFilter) throws IOException {
        JarFile jarFile = JarUtils.toJarFile(jarResourceURL);
        final String relativePath = JarUtils.resolveRelativePath(jarResourceURL);
        JarEntry jarEntry = jarFile.getJarEntry(relativePath);
        final boolean isDirectory = jarEntry.isDirectory();
        List<JarEntry> jarEntriesList = JarUtils.filter(jarFile, new JarEntryFilter(){

            @Override
            public boolean accept(JarEntry filteredObject) {
                String name = filteredObject.getName();
                if (isDirectory && name.equals(relativePath)) {
                    return true;
                }
                return name.startsWith(relativePath);
            }
        });
        jarEntriesList = JarUtils.doFilter(jarEntriesList, jarEntryFilter);
        JarUtils.doExtract(jarFile, jarEntriesList, targetDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doExtract(JarFile jarFile, Iterable<JarEntry> jarEntries, File targetDirectory) throws IOException {
        if (jarEntries != null) {
            for (JarEntry jarEntry : jarEntries) {
                String jarEntryName = jarEntry.getName();
                File targetFile = new File(targetDirectory, jarEntryName);
                if (jarEntry.isDirectory()) {
                    targetFile.mkdirs();
                    continue;
                }
                InputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream = jarFile.getInputStream(jarEntry);
                    if (inputStream == null) continue;
                    File parentFile = targetFile.getParentFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    outputStream = new FileOutputStream(targetFile);
                    IOUtils.copy(inputStream, outputStream);
                }
                finally {
                    IOUtils.close(outputStream);
                    IOUtils.close(inputStream);
                }
            }
        }
    }

    private JarUtils() {
    }
}

