/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.annotation;

import io.microsphere.redis.spring.annotation.EnableRedisInterceptor;
import io.microsphere.redis.spring.beans.RedisConnectionFactoryProxyBeanPostProcessor;
import io.microsphere.redis.spring.beans.RedisTemplateWrapperBeanPostProcessor;
import io.microsphere.redis.spring.beans.WrapperProcessors;
import io.microsphere.redis.spring.interceptor.EventPublishingRedisCommandInterceptor;
import io.microsphere.spring.util.BeanFactoryUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RedisInterceptorBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(RedisInterceptorBeanDefinitionRegistrar.class);
    private ConfigurableEnvironment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableRedisInterceptor.class.getName());
        String[] wrapRedisTemplates = (String[])attributes.get("wrapRedisTemplates");
        boolean exposeCommandEvent = (Boolean)attributes.get("exposeCommandEvent");
        Set<String> wrapRedisTemplateBeanNames = this.resolveWrappedRedisTemplateBeanNames(wrapRedisTemplates);
        this.registerBeanDefinitions(wrapRedisTemplateBeanNames, exposeCommandEvent, registry);
    }

    public void registerBeanDefinitions(Set<String> wrappedRedisTemplateBeanNames, boolean exposedCommandEvent, BeanDefinitionRegistry registry) {
        if (CollectionUtils.isEmpty(wrappedRedisTemplateBeanNames)) {
            this.addRedisConnectionFactoryProxyBeanPostProcessor(registry);
        } else {
            this.registerRedisTemplateWrapperBeanPostProcessor(wrappedRedisTemplateBeanNames, registry);
        }
        this.registerWrapperProcessors(registry);
        if (exposedCommandEvent) {
            this.registerEventPublishingRedisCommendInterceptor(registry);
        }
    }

    private void registerRedisTemplateWrapperBeanPostProcessor(Set<String> wrappedRedisTemplateBeanNames, BeanDefinitionRegistry registry) {
        this.registerBeanDefinition(registry, "redisTemplateWrapperBeanPostProcessor", RedisTemplateWrapperBeanPostProcessor.class, wrappedRedisTemplateBeanNames);
    }

    private Set<String> resolveWrappedRedisTemplateBeanNames(String[] wrapRedisTemplates) {
        LinkedHashSet<String> wrappedRedisTemplateBeanNames = new LinkedHashSet<String>();
        for (String wrapRedisTemplate : wrapRedisTemplates) {
            String wrappedRedisTemplateBeanName = this.environment.resolveRequiredPlaceholders(wrapRedisTemplate);
            Set beanNames = StringUtils.commaDelimitedListToSet((String)wrappedRedisTemplateBeanName);
            for (String beanName : beanNames) {
                wrappedRedisTemplateBeanName = StringUtils.trimWhitespace((String)beanName);
                if (!StringUtils.hasText((String)wrappedRedisTemplateBeanName)) continue;
                wrappedRedisTemplateBeanNames.add(wrappedRedisTemplateBeanName);
            }
        }
        return wrappedRedisTemplateBeanNames;
    }

    private void addRedisConnectionFactoryProxyBeanPostProcessor(BeanDefinitionRegistry registry) {
        ConfigurableBeanFactory beanFactory = BeanFactoryUtils.asConfigurableBeanFactory((Object)registry);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new RedisConnectionFactoryProxyBeanPostProcessor(beanFactory));
    }

    private void registerEventPublishingRedisCommendInterceptor(BeanDefinitionRegistry registry) {
        this.registerBeanDefinition(registry, "eventPublishingRedisCommendInterceptor", EventPublishingRedisCommandInterceptor.class, new Object[0]);
    }

    private void registerWrapperProcessors(BeanDefinitionRegistry registry) {
        this.registerBeanDefinition(registry, "wrapperProcessors", WrapperProcessors.class, new Object[0]);
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Object ... constructorArgs) {
        if (!registry.containsBeanDefinition(beanName)) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(beanClass);
            for (Object constructorArg : constructorArgs) {
                beanDefinitionBuilder.addConstructorArgValue(constructorArg);
            }
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
            logger.debug("Redis Interceptor Component[name : '{}' , class : {} , args : {}] registered", new Object[]{beanName, beanClass, Arrays.asList(constructorArgs)});
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }
}

