/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.beans;

import io.microsphere.redis.spring.context.RedisContext;
import io.microsphere.redis.spring.interceptor.InterceptingRedisConnectionInvocationHandler;
import io.microsphere.spring.beans.factory.config.GenericBeanPostProcessorAdapter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class RedisConnectionFactoryProxyBeanPostProcessor
extends GenericBeanPostProcessorAdapter<RedisConnectionFactory> {
    private static final Class[] REDIS_CONNECTION_TYPES = new Class[]{RedisConnection.class};
    private final ConfigurableBeanFactory beanFactory;

    public RedisConnectionFactoryProxyBeanPostProcessor(ConfigurableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected RedisConnectionFactory doPostProcessAfterInitialization(RedisConnectionFactory bean, final String beanName) throws BeansException {
        ProxyFactory proxyFactory = new ProxyFactory((Object)bean);
        proxyFactory.addAdvice((Advice)new MethodInterceptor(){

            @Nullable
            public Object invoke(@NonNull MethodInvocation invocation) throws Throwable {
                RedisContext redisContext;
                Method method = invocation.getMethod();
                method.setAccessible(true);
                String methodName = method.getName();
                Object result = invocation.proceed();
                if ("getConnection".equals(methodName) && result instanceof RedisConnection && (redisContext = RedisContext.get((BeanFactory)RedisConnectionFactoryProxyBeanPostProcessor.this.beanFactory)).isEnabled()) {
                    result = RedisConnectionFactoryProxyBeanPostProcessor.newProxyRedisConnection((RedisConnection)result, redisContext, beanName);
                }
                return result;
            }
        });
        return (RedisConnectionFactory)proxyFactory.getProxy();
    }

    private static RedisConnection newProxyRedisConnection(RedisConnection connection, RedisContext redisContext, String sourceBeanName) {
        ClassLoader classLoader = redisContext.getClassLoader();
        InvocationHandler invocationHandler = RedisConnectionFactoryProxyBeanPostProcessor.newInvocationHandler(connection, redisContext, sourceBeanName);
        return (RedisConnection)Proxy.newProxyInstance(classLoader, REDIS_CONNECTION_TYPES, invocationHandler);
    }

    private static InvocationHandler newInvocationHandler(RedisConnection connection, RedisContext redisContext, String sourceBeanName) {
        return new InterceptingRedisConnectionInvocationHandler(connection, redisContext, sourceBeanName);
    }
}

