/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.beans;

import io.microsphere.redis.spring.beans.DelegatingWrapper;
import io.microsphere.redis.spring.context.RedisContext;
import io.microsphere.redis.spring.interceptor.InterceptingRedisConnectionInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisTemplateWrapper<K, V>
extends RedisTemplate<K, V>
implements DelegatingWrapper {
    private static final Class<?>[] REDIS_CONNECTION_TYPES = new Class[]{RedisConnection.class};
    private final String beanName;
    private final RedisTemplate<K, V> delegate;
    private final RedisContext redisContext;

    public RedisTemplateWrapper(String beanName, RedisTemplate<K, V> delegate, RedisContext redisContext) {
        this.beanName = beanName;
        this.delegate = delegate;
        this.redisContext = redisContext;
        this.init();
    }

    private void init() {
        RedisTemplateWrapper.configure(this.delegate, this);
    }

    static void configure(RedisTemplate<?, ?> source, RedisTemplate<?, ?> target) {
        target.setConnectionFactory(source.getConnectionFactory());
        target.setExposeConnection(source.isExposeConnection());
        target.setEnableDefaultSerializer(source.isEnableDefaultSerializer());
        target.setDefaultSerializer(source.getDefaultSerializer());
        target.setKeySerializer(source.getKeySerializer());
        target.setValueSerializer(source.getValueSerializer());
        target.setHashKeySerializer(source.getHashKeySerializer());
        target.setHashValueSerializer(source.getHashValueSerializer());
        target.setStringSerializer(source.getStringSerializer());
    }

    protected RedisConnection preProcessConnection(RedisConnection connection, boolean existingConnection) {
        if (this.isEnabled()) {
            return RedisTemplateWrapper.newProxyRedisConnection(connection, this.redisContext, this.beanName);
        }
        return connection;
    }

    public boolean isEnabled() {
        return this.redisContext.isEnabled();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public RedisContext getRedisContext() {
        return this.redisContext;
    }

    protected static RedisConnection newProxyRedisConnection(RedisConnection connection, RedisContext redisContext, String sourceBeanName) {
        ClassLoader classLoader = redisContext.getClassLoader();
        InvocationHandler invocationHandler = RedisTemplateWrapper.newInvocationHandler(connection, redisContext, sourceBeanName);
        return (RedisConnection)Proxy.newProxyInstance(classLoader, REDIS_CONNECTION_TYPES, invocationHandler);
    }

    private static InvocationHandler newInvocationHandler(RedisConnection connection, RedisContext redisContext, String redisTemplateBeanName) {
        return new InterceptingRedisConnectionInvocationHandler(connection, redisContext, redisTemplateBeanName);
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }
}

