/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.beans;

import io.microsphere.redis.spring.beans.RedisTemplateWrapper;
import io.microsphere.redis.spring.beans.StringRedisTemplateWrapper;
import io.microsphere.redis.spring.beans.Wrapper;
import io.microsphere.redis.spring.beans.WrapperProcessors;
import io.microsphere.redis.spring.context.RedisContext;
import io.microsphere.redis.spring.util.RedisConstants;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.Assert;

public class RedisTemplateWrapperBeanPostProcessor
implements BeanPostProcessor,
InitializingBean,
ApplicationContextAware {
    public static final String BEAN_NAME = "redisTemplateWrapperBeanPostProcessor";
    private ConfigurableApplicationContext context;
    private RedisContext redisContext;
    private Set<String> wrappedRedisTemplateBeanNames;
    private WrapperProcessors wrapperProcessors;

    public RedisTemplateWrapperBeanPostProcessor() {
    }

    public RedisTemplateWrapperBeanPostProcessor(Collection<String> wrappedRedisTemplateBeanNames) {
        this.wrappedRedisTemplateBeanNames = new HashSet<String>(wrappedRedisTemplateBeanNames);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.wrappedRedisTemplateBeanNames.contains(beanName)) {
            Class beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
            if (StringRedisTemplate.class.equals((Object)beanClass)) {
                StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)bean;
                return this.process(new StringRedisTemplateWrapper(beanName, stringRedisTemplate, this.redisContext));
            }
            if (RedisTemplate.class.equals((Object)beanClass)) {
                RedisTemplate redisTemplate = (RedisTemplate)bean;
                return this.process(new RedisTemplateWrapper(beanName, redisTemplate, this.redisContext));
            }
        }
        return bean;
    }

    private <W extends Wrapper> W process(W wrapper) {
        return this.wrapperProcessors.process(wrapper);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)context, (String)"The 'context' argument must be an instance of ConfigurableApplicationContext");
        this.context = (ConfigurableApplicationContext)context;
    }

    private Set<String> resolveWrappedRedisTemplateBeanNames(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        Set wrappedRedisTemplateBeanNames = (Set)environment.getProperty("microsphere.redis.wrapped-redis-templates", Set.class);
        if (wrappedRedisTemplateBeanNames == null) {
            return Collections.emptySet();
        }
        if (RedisConstants.ALL_WRAPPED_REDIS_TEMPLATE_BEAN_NAMES.equals(wrappedRedisTemplateBeanNames)) {
            return this.redisContext.getRedisTemplateBeanNames();
        }
        return Collections.unmodifiableSet(wrappedRedisTemplateBeanNames);
    }

    public void afterPropertiesSet() throws Exception {
        this.redisContext = RedisContext.get((BeanFactory)this.context);
        if (this.wrappedRedisTemplateBeanNames == null) {
            this.wrappedRedisTemplateBeanNames = this.resolveWrappedRedisTemplateBeanNames(this.context);
        }
        this.wrapperProcessors = (WrapperProcessors)this.context.getBean("wrapperProcessors", WrapperProcessors.class);
    }

    public Set<String> getWrappedRedisTemplateBeanNames() {
        return this.wrappedRedisTemplateBeanNames;
    }
}

