/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.beans;

import io.microsphere.redis.spring.beans.DelegatingWrapper;
import io.microsphere.redis.spring.beans.RedisTemplateWrapper;
import io.microsphere.redis.spring.context.RedisContext;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;

public class StringRedisTemplateWrapper
extends StringRedisTemplate
implements DelegatingWrapper {
    private final String beanName;
    private final StringRedisTemplate delegate;
    private final RedisContext redisContext;

    public StringRedisTemplateWrapper(String beanName, StringRedisTemplate delegate, RedisContext redisContext) {
        this.beanName = beanName;
        this.delegate = delegate;
        this.redisContext = redisContext;
        this.init();
    }

    private void init() {
        RedisTemplateWrapper.configure(this.delegate, this);
    }

    protected RedisConnection preProcessConnection(RedisConnection connection, boolean existingConnection) {
        if (this.isEnabled()) {
            return RedisTemplateWrapper.newProxyRedisConnection(connection, this.redisContext, this.beanName);
        }
        return connection;
    }

    public boolean isEnabled() {
        return this.redisContext.isEnabled();
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }
}

