/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.beans;

import io.microsphere.redis.spring.beans.Wrapper;
import io.microsphere.redis.spring.beans.WrapperProcessor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class WrapperProcessors
implements InitializingBean,
BeanFactoryAware {
    public static final String BEAN_NAME = "wrapperProcessors";
    private ConfigurableListableBeanFactory beanFactory;
    private Map<Class<?>, ObjectProvider<WrapperProcessor>> wrapperHandlersMap;

    public <W extends Wrapper> W process(W wrapper) {
        Class<?> wrapperType = wrapper.getClass();
        ObjectProvider<WrapperProcessor> processors = this.wrapperHandlersMap.get(wrapperType);
        if (processors != null) {
            for (WrapperProcessor processor : processors) {
                wrapper = processor.process(wrapper);
            }
        }
        return wrapper;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"The 'beanFactory' is not a instance of ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.wrapperHandlersMap = this.initWrapperHandlersMap();
    }

    private Map<Class<?>, ObjectProvider<WrapperProcessor>> initWrapperHandlersMap() {
        HashMap wrapperHandlersMap = new HashMap(2);
        for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = this.beanFactory.getMergedBeanDefinition(beanName);
            ResolvableType resolvableType = beanDefinition.getResolvableType();
            Class beanClass = resolvableType.getRawClass();
            if (beanClass == null || !WrapperProcessor.class.isAssignableFrom(beanClass)) continue;
            Class redisTemplateClass = resolvableType.as(WrapperProcessor.class).getGeneric(new int[]{0}).getRawClass();
            wrapperHandlersMap.computeIfAbsent(redisTemplateClass, type -> this.beanFactory.getBeanProvider(resolvableType));
        }
        return wrapperHandlersMap;
    }
}

