/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.config;

import io.microsphere.redis.spring.event.RedisConfigurationPropertyChangedEvent;
import io.microsphere.redis.spring.util.RedisConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class RedisConfiguration
implements ApplicationListener<RedisConfigurationPropertyChangedEvent>,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RedisConfiguration.class);
    public static final String BEAN_NAME = "microsphere:redisConfiguration";
    protected ConfigurableApplicationContext context;
    protected ConfigurableEnvironment environment;
    protected String applicationName;
    protected volatile boolean enabled;

    public void onApplicationEvent(RedisConfigurationPropertyChangedEvent event) {
        if (event.hasProperty("microsphere.redis.enabled")) {
            this.setEnabled();
        }
    }

    public void setEnabled() {
        this.enabled = RedisConfiguration.isEnabled((ApplicationContext)this.context);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected String resolveApplicationName(Environment environment) {
        String applicationName = environment.getProperty("spring.application.name", "default");
        return applicationName;
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public boolean isCommandEventExposed() {
        return RedisConfiguration.isCommandEventExposed((ApplicationContext)this.context);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = (ConfigurableApplicationContext)context;
        this.environment = (ConfigurableEnvironment)context.getEnvironment();
        this.applicationName = this.resolveApplicationName((Environment)this.environment);
        this.setEnabled();
    }

    public static boolean isEnabled(ApplicationContext context) {
        return RedisConfiguration.getBoolean(context, "microsphere.redis.enabled", RedisConstants.DEFAULT_ENABLED, "Configuration", "enabled");
    }

    public static boolean isCommandEventExposed(ApplicationContext context) {
        return RedisConfiguration.getBoolean(context, "microsphere.redis.command-event.exposed", true, "Command Event", "exposed");
    }

    public static boolean getBoolean(ApplicationContext context, String propertyName, boolean defaultValue, String feature, String statusIfTrue) {
        boolean value;
        Environment environment = context.getEnvironment();
        Boolean propertyValue = (Boolean)environment.getProperty(propertyName, Boolean.class);
        boolean bl = value = propertyValue == null ? defaultValue : propertyValue;
        if (logger.isDebugEnabled()) {
            String status = value ? statusIfTrue : "not " + statusIfTrue;
            logger.debug("Microsphere Redis {} is '{}' in the Spring ApplicationContext[id :'{}' , property name: '{}' , property value: {} , default value: {}", new Object[]{feature, status, context.getId(), propertyName, propertyValue, defaultValue});
        }
        return value;
    }

    public static RedisConfiguration get(BeanFactory beanFactory) {
        return (RedisConfiguration)beanFactory.getBean(BEAN_NAME, RedisConfiguration.class);
    }
}

