/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.connection.dynamic;

import io.microsphere.text.FormatUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DynamicRedisConnectionFactory
implements RedisConnectionFactory,
SmartInitializingSingleton,
ApplicationContextAware,
BeanNameAware {
    public static final String DEFAULT_REDIS_CONNECTION_FACTORY_BEAN_NAME = "redisConnectionFactory";
    private static final Logger logger = LoggerFactory.getLogger(DynamicRedisConnectionFactory.class);
    private static final ThreadLocal<String> beanNameHolder = new ThreadLocal();
    private String beanName;
    private ApplicationContext context;
    private Map<String, RedisConnectionFactory> redisConnectionFactories;
    private String defaultRedisConnectionFactoryBeanName = "redisConnectionFactory";
    private RedisConnectionFactory defaultRedisConnectionFactory;

    public RedisConnection getConnection() {
        return this.determineTargetRedisConnectionFactory().getConnection();
    }

    public RedisClusterConnection getClusterConnection() {
        return this.determineTargetRedisConnectionFactory().getClusterConnection();
    }

    public boolean getConvertPipelineAndTxResults() {
        return this.determineTargetRedisConnectionFactory().getConvertPipelineAndTxResults();
    }

    public RedisSentinelConnection getSentinelConnection() {
        return this.determineTargetRedisConnectionFactory().getSentinelConnection();
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.determineTargetRedisConnectionFactory().translateExceptionIfPossible(ex);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        this.initialize();
    }

    public void setDefaultRedisConnectionFactoryBeanName(String defaultRedisConnectionFactoryBeanName) {
        this.defaultRedisConnectionFactoryBeanName = defaultRedisConnectionFactoryBeanName;
    }

    public String getDefaultRedisConnectionFactoryBeanName() {
        return this.defaultRedisConnectionFactoryBeanName;
    }

    protected void initialize() {
        this.redisConnectionFactories = this.resolveRedisConnectionFactories();
        this.defaultRedisConnectionFactory = this.resolveDefaultRedisConnectionFactory();
    }

    @NonNull
    protected RedisConnectionFactory determineTargetRedisConnectionFactory() {
        String targetBeanName = DynamicRedisConnectionFactory.getTargetBeanName();
        if (targetBeanName == null) {
            RedisConnectionFactory defaultRedisConnectionFactory = this.getDefaultRedisConnectionFactory();
            logger.debug("Current target Bean Name is not set or is executed in a multi-threaded environment, using the default RedisConnectionFactory Bean[name: '{}']", (Object)this.defaultRedisConnectionFactoryBeanName);
            return defaultRedisConnectionFactory;
        }
        logger.debug("Start toggle destination RedisConnectionFactory Bean[name: '{}']", (Object)targetBeanName);
        RedisConnectionFactory targetRedisConnectionFactory = this.getRedisConnectionFactory(targetBeanName);
        logger.debug("RedisConnectionFactory Bean[name: '{}']", (Object)targetBeanName);
        return targetRedisConnectionFactory;
    }

    protected RedisConnectionFactory getRedisConnectionFactory(String beanName) {
        Map<String, RedisConnectionFactory> redisConnectionFactories = this.getRedisConnectionFactories();
        RedisConnectionFactory redisConnectionFactory = redisConnectionFactories.get(beanName);
        Assert.notNull((Object)redisConnectionFactory, () -> FormatUtils.format((String)"RedisConnectionFactory Bean[name : '{}'] \u4e0d\u5b58\u5728", (Object[])new Object[]{beanName}));
        return redisConnectionFactory;
    }

    protected RedisConnectionFactory getDefaultRedisConnectionFactory() {
        if (this.defaultRedisConnectionFactory == null) {
            this.defaultRedisConnectionFactory = this.resolveDefaultRedisConnectionFactory();
        }
        return this.defaultRedisConnectionFactory;
    }

    protected Map<String, RedisConnectionFactory> getRedisConnectionFactories() {
        if (this.redisConnectionFactories == null) {
            this.redisConnectionFactories = this.resolveRedisConnectionFactories();
        }
        return this.redisConnectionFactories;
    }

    private RedisConnectionFactory resolveDefaultRedisConnectionFactory() {
        String beanName = this.defaultRedisConnectionFactoryBeanName;
        Assert.isTrue((boolean)StringUtils.hasText((String)beanName), (String)"The default RedisConnectionFactory Bean Name cannot be left blank");
        return this.getRedisConnectionFactory(beanName);
    }

    private Map<String, RedisConnectionFactory> resolveRedisConnectionFactories() {
        HashMap redisConnectionFactories = new HashMap(this.context.getBeansOfType(RedisConnectionFactory.class));
        redisConnectionFactories.remove(this.beanName);
        Assert.notEmpty(redisConnectionFactories, (String)"RedisConnectionFactory Beans do not exist");
        return Collections.unmodifiableMap(redisConnectionFactories);
    }

    public static void switchTarget(String redisConnectionFactoryBeanName) {
        beanNameHolder.set(redisConnectionFactoryBeanName);
        logger.debug("Switch target RedisConnectionFactory Bean Name: '{}'", (Object)redisConnectionFactoryBeanName);
    }

    public static void clearTarget() {
        String targetBeanName = DynamicRedisConnectionFactory.getTargetBeanName();
        beanNameHolder.remove();
        logger.debug("Clear target RedisConnectionFactory Bean Name: '{}'", (Object)targetBeanName);
    }

    protected static String getTargetBeanName() {
        return beanNameHolder.get();
    }
}

