/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.context;

import io.microsphere.redis.spring.config.RedisConfiguration;
import io.microsphere.redis.spring.interceptor.RedisCommandInterceptor;
import io.microsphere.redis.spring.interceptor.RedisConnectionInterceptor;
import io.microsphere.spring.util.BeanUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.NonNull;

public class RedisContext
implements SmartInitializingSingleton,
ApplicationContextAware,
BeanFactoryAware,
BeanClassLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(RedisConfiguration.class);
    public static final String BEAN_NAME = "redisContext";
    private static final Class<RedisTemplate> REDIS_TEMPLATE_CLASS = RedisTemplate.class;
    private static final Class<RedisConfiguration> REDIS_CONFIGURATION_CLASS = RedisConfiguration.class;
    private ConfigurableListableBeanFactory beanFactory;
    private ConfigurableApplicationContext context;
    private ClassLoader classLoader;
    private RedisConfiguration redisConfiguration;
    private Set<String> redisTemplateBeanNames;
    private Set<String> redisConnectionFactoryBeanNames;
    private List<RedisConnectionInterceptor> redisConnectionInterceptors;
    private List<RedisCommandInterceptor> redisCommandInterceptors;

    public void afterSingletonsInstantiated() {
        this.redisConfiguration = RedisConfiguration.get((BeanFactory)this.context);
        this.redisTemplateBeanNames = RedisContext.findRestTemplateBeanNames(this.beanFactory);
        this.redisConnectionFactoryBeanNames = this.findRedisConnectionFactoryBeanNames(this.beanFactory);
        this.redisConnectionInterceptors = RedisContext.findRedisConnectionInterceptors((ListableBeanFactory)this.beanFactory);
        this.redisCommandInterceptors = RedisContext.findRedisCommandInterceptors((ListableBeanFactory)this.beanFactory);
    }

    @NonNull
    public RedisConfiguration getRedisConfiguration() {
        RedisConfiguration redisConfiguration = this.redisConfiguration;
        if (redisConfiguration == null) {
            logger.debug("RedisConfiguration is not initialized, it will be got from BeanFactory[{}]", (Object)this.beanFactory);
            this.redisConfiguration = redisConfiguration = RedisConfiguration.get((BeanFactory)this.beanFactory);
        }
        return redisConfiguration;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.context;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Set<String> getRedisTemplateBeanNames() {
        return this.redisTemplateBeanNames;
    }

    public Set<String> getRedisConnectionFactoryBeanNames() {
        return this.redisConnectionFactoryBeanNames;
    }

    public boolean isEnabled() {
        return this.getRedisConfiguration().isEnabled();
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.getRedisConfiguration().getEnvironment();
    }

    public boolean isCommandEventExposed() {
        return this.getRedisConfiguration().isCommandEventExposed();
    }

    public String getApplicationName() {
        return this.getRedisConfiguration().getApplicationName();
    }

    public List<RedisConnectionInterceptor> getRedisConnectionInterceptors() {
        return this.redisConnectionInterceptors;
    }

    public List<RedisCommandInterceptor> getRedisCommandInterceptors() {
        return this.redisCommandInterceptors;
    }

    public RedisTemplate<?, ?> getRedisTemplate(String redisTemplateBeanName) {
        return RedisContext.getRedisTemplate((BeanFactory)this.context, redisTemplateBeanName);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static RedisContext get(BeanFactory beanFactory) {
        return (RedisContext)beanFactory.getBean(RedisContext.class);
    }

    public static RedisTemplate<?, ?> getRedisTemplate(BeanFactory beanFactory, String redisTemplateBeanName) {
        if (beanFactory.containsBean(redisTemplateBeanName)) {
            return (RedisTemplate)beanFactory.getBean(redisTemplateBeanName, REDIS_TEMPLATE_CLASS);
        }
        return null;
    }

    public static Set<String> findRestTemplateBeanNames(ConfigurableListableBeanFactory beanFactory) {
        List<String> redisTemplateBeanNames = Arrays.asList(BeanUtils.getBeanNames((ConfigurableListableBeanFactory)beanFactory, RedisTemplate.class));
        logger.debug("The all bean names of RedisTemplate : {}", redisTemplateBeanNames);
        return Collections.unmodifiableSet(new HashSet<String>(redisTemplateBeanNames));
    }

    public Set<String> findRedisConnectionFactoryBeanNames(ConfigurableListableBeanFactory beanFactory) {
        List<String> redisConnectionFactoryBeanNames = Arrays.asList(BeanUtils.getBeanNames((ConfigurableListableBeanFactory)beanFactory, RedisConnectionFactory.class));
        logger.debug("The all bean names of RedisConnectionFactory : {}", redisConnectionFactoryBeanNames);
        return Collections.unmodifiableSet(new HashSet<String>(redisConnectionFactoryBeanNames));
    }

    public static List<RedisCommandInterceptor> findRedisCommandInterceptors(ListableBeanFactory beanFactory) {
        return BeanUtils.getSortedBeans((ListableBeanFactory)beanFactory, RedisCommandInterceptor.class);
    }

    public static List<RedisConnectionInterceptor> findRedisConnectionInterceptors(ListableBeanFactory beanFactory) {
        return BeanUtils.getSortedBeans((ListableBeanFactory)beanFactory, RedisConnectionInterceptor.class);
    }
}

