/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.context;

import io.microsphere.redis.spring.config.RedisConfiguration;
import io.microsphere.redis.spring.context.RedisModuleInitializer;
import io.microsphere.spring.util.PropertySourcesUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class RedisInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger logger = LoggerFactory.getLogger(RedisInitializer.class);

    public void initialize(ConfigurableApplicationContext context) {
        if (this.supports(context)) {
            ClassLoader classLoader = context.getClassLoader();
            List redisModuleInitializers = SpringFactoriesLoader.loadFactories(RedisModuleInitializer.class, (ClassLoader)classLoader);
            AnnotationAwareOrderComparator.sort((List)redisModuleInitializers);
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            for (RedisModuleInitializer redisModuleInitializer : redisModuleInitializers) {
                boolean supports = redisModuleInitializer.supports(context, registry);
                logger.debug("ApplicationContext[id : '{}'] {} support to initialize RedisModuleInitializer[class : {} , order : {}]", new Object[]{context.getId(), supports ? "does" : "does not", redisModuleInitializer.getClass(), redisModuleInitializer.getOrder()});
                if (!supports) continue;
                redisModuleInitializer.initialize(context, registry);
            }
        }
    }

    private boolean supports(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            logger.warn("The application context [id: {}, class: {}]'s BeanFactory[class : {}] is not a {} type", new Object[]{context.getId(), context.getClass(), beanFactory.getClass(), AnnotationConfigRegistry.class});
            return false;
        }
        if (!RedisConfiguration.isEnabled((ApplicationContext)context)) {
            return false;
        }
        return !this.isBootstrapContext(context);
    }

    private boolean isBootstrapContext(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        return PropertySourcesUtils.containsBootstrapPropertySource((ConfigurableEnvironment)environment);
    }
}

