/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.context;

import io.microsphere.redis.spring.annotation.EnableRedisInterceptor;
import io.microsphere.redis.spring.config.RedisConfiguration;
import io.microsphere.redis.spring.context.RedisModuleInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class RedisInterceptorModuleInitializer
implements RedisModuleInitializer {
    private static final Logger logger = LoggerFactory.getLogger(RedisInterceptorModuleInitializer.class);

    @Override
    public boolean supports(ConfigurableApplicationContext context, BeanDefinitionRegistry registry) {
        String propertyName;
        ConfigurableEnvironment environment = context.getEnvironment();
        boolean enabled = (Boolean)environment.getProperty(propertyName = "microsphere.redis.interceptor.enabled", Boolean.TYPE, (Object)true);
        logger.debug("Microsphere Redis Interceptor is '{}'", (Object)(enabled ? "Enabled" : "Disabled"));
        return enabled;
    }

    @Override
    public void initialize(ConfigurableApplicationContext context, BeanDefinitionRegistry registry) {
        ConfigurableEnvironment environment = context.getEnvironment();
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(registry, (Environment)environment);
        Class configClass = RedisConfiguration.isCommandEventExposed((ApplicationContext)context) ? Config.class : NoExposingCommandEventConfig.class;
        reader.register(new Class[]{configClass});
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @EnableRedisInterceptor(wrapRedisTemplates={"${microsphere.redis.wrapped-redis-templates:}"}, exposeCommandEvent=false)
    private static class NoExposingCommandEventConfig {
        private NoExposingCommandEventConfig() {
        }
    }

    @EnableRedisInterceptor(wrapRedisTemplates={"${microsphere.redis.wrapped-redis-templates:}"})
    private static class Config {
        private Config() {
        }
    }
}

