/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.event;

import io.microsphere.redis.spring.event.RedisConfigurationPropertyChangedEvent;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;

public class PropagatingRedisConfigurationPropertyChangedEventApplicationListener
implements SmartApplicationListener {
    public static final String ENVIRONMENT_CHANGE_EVENT_CLASS_NAME = "org.springframework.cloud.context.environment.EnvironmentChangeEvent";
    private final ConfigurableApplicationContext context;

    public PropagatingRedisConfigurationPropertyChangedEventApplicationListener(ConfigurableApplicationContext context) {
        this.context = context;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ENVIRONMENT_CHANGE_EVENT_CLASS_NAME.equals(eventType.getName());
    }

    public void onApplicationEvent(ApplicationEvent e) {
        EnvironmentChangeEvent environmentChangeEvent = (EnvironmentChangeEvent)e;
        Set<String> keys = environmentChangeEvent.getKeys().stream().filter(this::isRedisPropertyName).collect(Collectors.toSet());
        RedisConfigurationPropertyChangedEvent event = new RedisConfigurationPropertyChangedEvent(this.context, keys);
        this.context.publishEvent((ApplicationEvent)event);
    }

    private boolean isRedisPropertyName(String key) {
        return key != null && key.startsWith("microsphere.redis.");
    }
}

