/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.event;

import io.microsphere.redis.spring.interceptor.RedisMethodContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class RedisCommandEvent
extends ApplicationEvent {
    private static final long serialVersionUID = -1L;
    private final transient String applicationName;
    private final transient String sourceBeanName;
    private final transient Method method;
    private final transient Object[] args;
    private transient String interfaceName;
    private transient Class<?>[] parameterTypes;
    private transient int parameterCount = -1;
    private transient byte serializationVersion = 1;

    protected RedisCommandEvent(Object source, String applicationName, String sourceBeanName, Method method, Object ... args) {
        super(source);
        this.applicationName = applicationName;
        this.sourceBeanName = sourceBeanName;
        this.method = method;
        this.args = args;
    }

    public RedisCommandEvent(@NonNull RedisMethodContext redisMethodContext) {
        this(redisMethodContext, redisMethodContext.getApplicationName(), redisMethodContext.getSourceBeanName(), redisMethodContext.getMethod(), redisMethodContext.getArgs());
    }

    @NonNull
    public Method getMethod() {
        return this.method;
    }

    public String getInterfaceName() {
        String interfaceName = this.interfaceName;
        if (interfaceName == null) {
            this.interfaceName = interfaceName = this.resolveInterfaceName(this.method);
        }
        return interfaceName;
    }

    private String resolveInterfaceName(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        String className = declaringClass.getName();
        return className;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Class<?>[] getParameterTypes() {
        Class<?>[] parameterTypes = this.parameterTypes;
        if (parameterTypes == null) {
            this.parameterTypes = parameterTypes = this.method.getParameterTypes();
        }
        return parameterTypes;
    }

    public int getParameterCount() {
        int parameterCount = this.parameterCount;
        if (parameterCount == -1) {
            this.parameterCount = parameterCount = this.method.getParameterCount();
        }
        return parameterCount;
    }

    @Nullable
    public Object[] getArgs() {
        return this.args;
    }

    @Nullable
    public Object getArg(int index) {
        return this.args[index];
    }

    @NonNull
    public String getApplicationName() {
        return this.applicationName;
    }

    @Nullable
    public String getSourceBeanName() {
        return this.sourceBeanName;
    }

    public void setSerializationVersion(byte serializationVersion) {
        this.serializationVersion = serializationVersion;
    }

    public byte getSerializationVersion() {
        return this.serializationVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RedisCommandEvent that = (RedisCommandEvent)((Object)o);
        return Objects.equals(this.applicationName, that.applicationName) && Objects.equals(this.sourceBeanName, that.sourceBeanName) && Objects.equals(this.method, that.method) && Arrays.deepEquals(this.args, that.args);
    }

    public int hashCode() {
        int result = Objects.hash(this.applicationName, this.sourceBeanName, this.method);
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", RedisCommandEvent.class.getSimpleName() + "[", "]").add("applicationName='" + this.applicationName + "'").add("sourceBeanName='" + this.sourceBeanName + "'").add("method=" + this.method).add("args=" + Arrays.toString(this.args)).toString();
    }

    public static class Builder {
        private final Object source;
        private String applicationName;
        private String sourceBeanName;
        private Method method;
        private Object[] args;
        private byte serializationVersion = 0;

        protected Builder(Object source) {
            this.source = source;
        }

        public static Builder source(Object source) {
            return new Builder(source);
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder sourceBeanName(String sourceBeanName) {
            this.sourceBeanName = sourceBeanName;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder args(Object ... args) {
            this.args = args;
            return this;
        }

        public Builder serializationVersion(byte serializationVersion) {
            this.serializationVersion = serializationVersion;
            return this;
        }

        public Method getMethod() {
            return this.method;
        }

        public RedisCommandEvent build() {
            RedisCommandEvent redisCommandEvent = new RedisCommandEvent(this.source, this.applicationName, this.sourceBeanName, this.method, this.args);
            redisCommandEvent.setSerializationVersion(this.serializationVersion);
            return redisCommandEvent;
        }
    }
}

