/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.event;

import io.microsphere.redis.spring.config.RedisConfiguration;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.core.env.Environment;

public class RedisConfigurationPropertyChangedEvent
extends ApplicationContextEvent {
    private final Environment environment;
    private final Set<String> propertyNames;

    public RedisConfigurationPropertyChangedEvent(ConfigurableApplicationContext source, Set<String> propertyNames) {
        super((ApplicationContext)source);
        this.environment = source.getEnvironment();
        this.propertyNames = propertyNames;
    }

    public ConfigurableApplicationContext getSource() {
        return (ConfigurableApplicationContext)super.getSource();
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    public boolean hasProperty(String propertyName) {
        return this.propertyNames.contains(propertyName);
    }

    public RedisConfiguration getRedisConfiguration() {
        return RedisConfiguration.get((BeanFactory)this.getSource());
    }
}

