/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.interceptor;

import io.microsphere.redis.spring.context.RedisContext;
import io.microsphere.redis.spring.event.RedisCommandEvent;
import io.microsphere.redis.spring.event.RedisConfigurationPropertyChangedEvent;
import io.microsphere.redis.spring.interceptor.RedisCommandInterceptor;
import io.microsphere.redis.spring.interceptor.RedisMethodContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.data.redis.connection.RedisCommands;

public class EventPublishingRedisCommandInterceptor
implements RedisCommandInterceptor,
ApplicationListener<RedisConfigurationPropertyChangedEvent>,
ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(EventPublishingRedisCommandInterceptor.class);
    public static final String BEAN_NAME = "eventPublishingRedisCommendInterceptor";
    private final RedisContext redisContext;
    private final String applicationName;
    private ApplicationEventPublisher applicationEventPublisher;
    private volatile boolean enabled = false;

    public EventPublishingRedisCommandInterceptor(RedisContext redisContext) {
        this.redisContext = redisContext;
        this.applicationName = redisContext.getApplicationName();
        this.setEnabled();
    }

    public void setEnabled() {
        this.enabled = this.redisContext.isCommandEventExposed();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void afterExecute(RedisMethodContext<RedisCommands> context, Object result, Throwable failure) throws Throwable {
        if (this.isEnabled() && failure == null && context.isWriteMethod(true)) {
            this.publishRedisCommandEvent(context);
        }
    }

    private void publishRedisCommandEvent(RedisMethodContext<RedisCommands> context) {
        RedisCommandEvent redisCommandEvent = this.createRedisCommandEvent(context);
        if (redisCommandEvent != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)redisCommandEvent);
        }
    }

    private RedisCommandEvent createRedisCommandEvent(RedisMethodContext<RedisCommands> redisMethodContext) {
        RedisCommandEvent redisCommandEvent = new RedisCommandEvent(redisMethodContext);
        return redisCommandEvent;
    }

    public void onApplicationEvent(RedisConfigurationPropertyChangedEvent event) {
        if (event.hasProperty("microsphere.redis.command-event.exposed")) {
            this.setEnabled();
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

