/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.interceptor;

import io.microsphere.redis.spring.context.RedisContext;
import io.microsphere.redis.spring.interceptor.RedisCommandInterceptor;
import io.microsphere.redis.spring.interceptor.RedisConnectionInterceptor;
import io.microsphere.redis.spring.interceptor.RedisMethodContext;
import io.microsphere.redis.spring.interceptor.RedisMethodInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;

public class InterceptingRedisConnectionInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(InterceptingRedisConnectionInvocationHandler.class);
    private static final String HASH_CODE = "hashCode";
    private static final String EQUALS = "equals";
    private final RedisConnection rawRedisConnection;
    private final RedisContext redisContext;
    private final String sourceBeanName;
    private final List<RedisConnectionInterceptor> redisConnectionInterceptors;
    private final List<RedisCommandInterceptor> redisCommandInterceptors;
    private final int redisConnectionInterceptorCount;
    private final int redisCommandInterceptorCount;
    private final boolean hasRedisConnectionInterceptors;
    private final boolean hasRedisCommandInterceptors;

    public InterceptingRedisConnectionInvocationHandler(RedisConnection rawRedisConnection, RedisContext redisContext, String sourceBeanName) {
        this.rawRedisConnection = rawRedisConnection;
        this.redisContext = redisContext;
        this.sourceBeanName = sourceBeanName;
        this.redisConnectionInterceptors = redisContext.getRedisConnectionInterceptors();
        this.redisCommandInterceptors = redisContext.getRedisCommandInterceptors();
        this.redisConnectionInterceptorCount = this.redisConnectionInterceptors.size();
        this.redisCommandInterceptorCount = this.redisCommandInterceptors.size();
        this.hasRedisConnectionInterceptors = this.redisConnectionInterceptorCount > 0;
        this.hasRedisCommandInterceptors = this.redisCommandInterceptorCount > 0;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (EQUALS.equals(methodName)) {
            return proxy == args[0];
        }
        if (HASH_CODE.equals(methodName)) {
            return System.identityHashCode(proxy);
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        RedisMethodContext<RedisConnection> redisMethodContext = this.createRedisMethodContext(method, args);
        Object result = null;
        Throwable failure = null;
        try {
            this.beforeExecute(redisMethodContext);
            result = method.invoke((Object)this.rawRedisConnection, args);
            this.afterExecute(redisMethodContext, result, failure);
        }
        catch (Throwable e) {
            try {
                failure = e;
                throw e.getCause();
            }
            catch (Throwable throwable) {
                this.afterExecute(redisMethodContext, result, failure);
                throw throwable;
            }
        }
        return result;
    }

    private RedisMethodContext<RedisConnection> createRedisMethodContext(Method method, Object[] args) {
        RedisMethodContext<RedisConnection> redisMethodContext = new RedisMethodContext<RedisConnection>(this.rawRedisConnection, method, args, this.redisContext, this.sourceBeanName);
        return redisMethodContext;
    }

    private void beforeExecute(RedisMethodContext<RedisConnection> redisMethodContext) {
        this.beforeExecute(this.redisConnectionInterceptors, this.redisConnectionInterceptorCount, this.hasRedisConnectionInterceptors, redisMethodContext);
        this.beforeExecute(this.redisCommandInterceptors, this.redisCommandInterceptorCount, this.hasRedisCommandInterceptors, redisMethodContext);
    }

    private void beforeExecute(List<? extends RedisMethodInterceptor> redisMethodInterceptors, int size, boolean exists, RedisMethodContext<RedisConnection> redisMethodContext) {
        if (exists) {
            for (int i = 0; i < size; ++i) {
                RedisMethodInterceptor interceptor = redisMethodInterceptors.get(i);
                try {
                    interceptor.beforeExecute(redisMethodContext);
                    continue;
                }
                catch (Throwable e) {
                    interceptor.handleError(redisMethodContext, true, null, null, e);
                    logger.error("The execution of RedisMethodInterceptor[class : '{}'] beforeExecute method is failed, context : {}", (Object)interceptor.getClass().getName(), redisMethodContext);
                }
            }
        }
    }

    private void afterExecute(RedisMethodContext<RedisConnection> redisMethodContext, Object result, Throwable failure) {
        this.afterExecute(this.redisConnectionInterceptors, this.redisConnectionInterceptorCount, this.hasRedisConnectionInterceptors, redisMethodContext, result, failure);
        this.afterExecute(this.redisCommandInterceptors, this.redisCommandInterceptorCount, this.hasRedisCommandInterceptors, redisMethodContext, result, failure);
    }

    private void afterExecute(List<? extends RedisMethodInterceptor> redisMethodInterceptors, int size, boolean exists, RedisMethodContext<RedisConnection> redisMethodContext, Object result, Throwable failure) {
        if (exists) {
            for (int i = 0; i < size; ++i) {
                RedisMethodInterceptor interceptor = redisMethodInterceptors.get(i);
                try {
                    interceptor.afterExecute(redisMethodContext, result, failure);
                    continue;
                }
                catch (Throwable e) {
                    interceptor.handleError(redisMethodContext, false, result, failure, e);
                    logger.error("The execution of RedisMethodInterceptor[class : '{}'] afterExecute method is failed, context : {}, result : {} , failure : {}", new Object[]{interceptor.getClass().getName(), redisMethodContext, result, failure});
                }
            }
        }
    }
}

