/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.interceptor;

import io.microsphere.redis.spring.config.RedisConfiguration;
import io.microsphere.redis.spring.context.RedisContext;
import io.microsphere.redis.spring.metadata.Parameter;
import io.microsphere.redis.spring.metadata.RedisMetadataRepository;
import io.microsphere.redis.spring.util.RedisCommandsUtils;
import io.microsphere.util.ArrayUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.NonNull;

public class RedisMethodContext<T> {
    private static final Logger logger = LoggerFactory.getLogger(RedisMethodContext.class);
    private static final Parameter[] EMPTY_PARAMETERS = new Parameter[0];
    private static final ThreadLocal<RedisMethodContext<?>> redisMethodContextThreadLocal = new ThreadLocal();
    private final T target;
    private final Method method;
    private final Object[] args;
    private Parameter[] parameters = null;
    private Map<Object, Parameter> parametersMap = null;
    private Integer parameterCount = null;
    private Boolean write = null;
    private final RedisContext redisContext;
    private final String sourceBeanName;
    private Boolean sourceFromRedisTemplate = null;
    private Boolean sourceFromRedisConnectionFactory = null;
    private long startTimeNanos = -1L;
    private long durationNanos = -1L;
    private Map<String, Object> attributes;

    public RedisMethodContext(T target, Method method, Object[] args, RedisContext redisContext) {
        this(target, method, args, redisContext, null);
    }

    public RedisMethodContext(T target, Method method, Object[] args, RedisContext redisContext, String sourceBeanName) {
        this.target = target;
        this.method = method;
        this.args = args;
        this.redisContext = redisContext;
        this.sourceBeanName = sourceBeanName;
    }

    public T getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getSourceBeanName() {
        return this.sourceBeanName;
    }

    public RedisContext getRedisContext() {
        return this.redisContext;
    }

    private void initParameters() {
        boolean write;
        Map parametersMap;
        Parameter[] parameters;
        int size = ArrayUtils.length((Object[])this.args);
        if (size > 1) {
            parameters = new Parameter[size];
            parametersMap = new HashMap(size);
            write = RedisCommandsUtils.initParameters(this.method, this.args, (parameter, index) -> {
                parameters[index.intValue()] = parameter;
                parametersMap.put(parameter.getValue(), parameter);
            }, new BiConsumer[0]);
        } else {
            parameters = EMPTY_PARAMETERS;
            parametersMap = Collections.emptyMap();
            write = false;
        }
        this.parameters = parameters;
        this.parametersMap = Collections.unmodifiableMap(parametersMap);
        this.write = write;
    }

    public void start() {
        this.startTimeNanos = System.nanoTime();
    }

    public void stop() {
        if (this.startTimeNanos < 0L) {
            throw new IllegalStateException("'stop()' method must not be invoked before the execution of 'start()' method");
        }
        this.durationNanos = System.nanoTime() - this.startTimeNanos;
    }

    public <T> void setAttribute(String name, T value) {
        Map<String, Object> attributes = this.getAttributes(true);
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
            this.attributes = attributes;
        }
        attributes.put(name, value);
    }

    public <T> T getAttribute(String name) {
        return this.doInAttributes(attributes -> attributes.get(name));
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public <T> T removeAttribute(String name) {
        return this.doInAttributes(attributes -> attributes.remove(name));
    }

    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = this.getAttributes(false);
        return attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(attributes);
    }

    private <T> T doInAttributes(Function<Map<String, Object>, Object> function) {
        return this.doInAttributes(false, function);
    }

    private <T> T doInAttributes(boolean created, Function<Map<String, Object>, Object> function) {
        Map<String, Object> attributes = this.getAttributes(created);
        if (attributes != null) {
            return (T)function.apply(attributes);
        }
        return null;
    }

    private Map<String, Object> getAttributes(boolean created) {
        Map<String, Object> attributes = this.attributes;
        if (attributes == null && created) {
            this.attributes = attributes = new HashMap<String, Object>();
        }
        return attributes;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public long getDurationNanos() {
        return this.durationNanos;
    }

    public long getDuration(TimeUnit timeUnit) {
        long durationNanos = this.getDurationNanos();
        if (durationNanos < 0L) {
            return durationNanos;
        }
        return timeUnit.convert(durationNanos, TimeUnit.NANOSECONDS);
    }

    public boolean isWriteMethod() {
        if (this.write == null) {
            return this.isWriteMethod(false);
        }
        return this.write;
    }

    public boolean isWriteMethod(boolean initializedParameters) {
        if (initializedParameters) {
            this.initParameters();
        } else {
            this.write = RedisMetadataRepository.isWriteCommandMethod(this.method);
        }
        return this.write;
    }

    public Map<Object, Parameter> getParametersMap() {
        if (this.parametersMap == null) {
            this.initParameters();
        }
        return this.parametersMap;
    }

    public Parameter[] getParameters() {
        if (this.parameters == null) {
            this.initParameters();
        }
        return this.parameters;
    }

    public int getParameterCount() {
        if (this.parameterCount == null) {
            this.initParameters();
        }
        return this.parameterCount;
    }

    public Parameter getParameterMap(Object parameterValue) {
        return this.getParametersMap().get(parameterValue);
    }

    public Parameter getParameter(int index) {
        return this.getParameters()[index];
    }

    @NonNull
    public RedisConfiguration getRedisConfiguration() {
        return this.redisContext.getRedisConfiguration();
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.redisContext.getBeanFactory();
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.redisContext.getApplicationContext();
    }

    public ClassLoader getClassLoader() {
        return this.redisContext.getClassLoader();
    }

    public Set<String> getRedisTemplateBeanNames() {
        return this.redisContext.getRedisTemplateBeanNames();
    }

    public Set<String> getRedisConnectionFactoryBeanNames() {
        return this.redisContext.getRedisConnectionFactoryBeanNames();
    }

    public boolean isEnabled() {
        return this.redisContext.isEnabled();
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.redisContext.getEnvironment();
    }

    public boolean isCommandEventExposed() {
        return this.redisContext.isCommandEventExposed();
    }

    public String getApplicationName() {
        return this.redisContext.getApplicationName();
    }

    public boolean isSourceFromRedisTemplate() {
        Boolean sourceFromRedisTemplate = this.sourceFromRedisTemplate;
        if (sourceFromRedisTemplate == null) {
            this.sourceFromRedisTemplate = sourceFromRedisTemplate = Boolean.valueOf(this.redisContext.getRedisTemplateBeanNames().contains(this.sourceBeanName));
        }
        return sourceFromRedisTemplate;
    }

    public boolean isSourceFromRedisConnectionFactory() {
        Boolean sourceFromRedisConnectionFactory = this.sourceFromRedisConnectionFactory;
        if (sourceFromRedisConnectionFactory == null) {
            this.sourceFromRedisConnectionFactory = sourceFromRedisConnectionFactory = Boolean.valueOf(this.redisContext.getRedisConnectionFactoryBeanNames().contains(this.sourceBeanName));
        }
        return sourceFromRedisConnectionFactory;
    }

    public void setParameters(Parameter[] parameters) {
        this.parameters = parameters;
    }

    public void setParametersMap(Map<Object, Parameter> parametersMap) {
        this.parametersMap = parametersMap;
    }

    public String toString() {
        return new StringJoiner(", ", RedisMethodContext.class.getSimpleName() + "[", "]").add("target=" + this.target).add("method=" + this.method).add("args=" + Arrays.toString(this.args)).add("write=" + this.write).add("parameters=" + this.parameters).add("redisContext=" + this.redisContext).add("sourceBeanName='" + this.sourceBeanName + "'").add("startTimeNanos=" + this.startTimeNanos).add("durationNanos=" + this.durationNanos).toString();
    }

    public static void set(RedisMethodContext redisMethodContext) {
        redisMethodContextThreadLocal.set(redisMethodContext);
        logger.debug("{} stores into ThreadLocal", (Object)redisMethodContext);
    }

    public static <T> RedisMethodContext<T> get() {
        return redisMethodContextThreadLocal.get();
    }

    public static void clear() {
        redisMethodContextThreadLocal.remove();
    }
}

