/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.metadata;

import io.microsphere.redis.spring.event.RedisCommandEvent;
import io.microsphere.redis.spring.metadata.MethodMetadata;
import io.microsphere.redis.spring.metadata.ParameterMetadata;
import io.microsphere.redis.spring.metadata.RedisMetadata;
import io.microsphere.redis.spring.util.RedisCommandsUtils;
import io.microsphere.redis.spring.util.RedisConstants;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisCommands;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.ReflectionUtils;
import org.yaml.snakeyaml.Yaml;

@Deprecated
public class MethodMetadataRepository {
    private static final Logger logger = LoggerFactory.getLogger(MethodMetadataRepository.class);
    private static volatile boolean initialized = false;
    static final Map<String, Class<?>> redisCommandInterfacesCache = new HashMap();
    static final Map<String, Function<RedisConnection, Object>> redisCommandBindings = new HashMap<String, Function<RedisConnection, Object>>();
    static final Map<Method, List<ParameterMetadata>> writeCommandMethodsMetadata = new HashMap<Method, List<ParameterMetadata>>();
    static final Map<String, Method> writeCommandMethodsCache = new HashMap<String, Method>();
    static RedisMetadata redisMetadata;

    public static void init() {
        if (initialized) {
            return;
        }
        MethodMetadataRepository.initRedisMetadata();
        MethodMetadataRepository.initRedisMethodsAccessible();
        MethodMetadataRepository.initRedisCommandsInterfaces();
        MethodMetadataRepository.initWriteCommandMethods();
        initialized = true;
    }

    private static void initRedisMetadata() {
        redisMetadata = MethodMetadataRepository.loadRedisMetadata();
    }

    private static RedisMetadata loadRedisMetadata() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        RedisMetadata redisMetadata = new RedisMetadata();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("classpath*:/META-INF/redis-metadata.yaml")) {
                redisMetadata.merge(MethodMetadataRepository.loadRedisMetadata(resource));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return redisMetadata;
    }

    private static RedisMetadata loadRedisMetadata(Resource resource) throws IOException {
        Yaml yaml = new Yaml();
        RedisMetadata redisMetadata = (RedisMetadata)yaml.loadAs(resource.getInputStream(), RedisMetadata.class);
        return redisMetadata;
    }

    public static boolean isWriteCommandMethod(Method method) {
        return writeCommandMethodsMetadata.containsKey(method);
    }

    public static List<ParameterMetadata> getWriteParameterMetadataList(Method method) {
        return writeCommandMethodsMetadata.get(method);
    }

    public static Method findWriteCommandMethod(RedisCommandEvent event) {
        return event.getMethod();
    }

    public static Method findWriteCommandMethod(String interfaceNme, String methodName, String[] parameterTypes) {
        Method method = MethodMetadataRepository.getWriteCommandMethod(interfaceNme, methodName, parameterTypes);
        if (method == null) {
            logger.warn("Redis event publishers and consumers have different apis. Please update consumer microsphere-spring-redis artifacts in time!");
            logger.debug("Redis command methods will use Java reflection to find (interface :{}, method name :{}, parameter list :{})...", new Object[]{interfaceNme, methodName, Arrays.toString(parameterTypes)});
            Class<?> interfaceClass = MethodMetadataRepository.getRedisCommandsInterfaceClass(interfaceNme);
            if (interfaceClass == null) {
                logger.warn("The current Redis consumer cannot find Redis command interface: {}. Please confirm whether the spring-data artifacts API is compatible.", (Object)interfaceNme);
                return null;
            }
            Class[] parameterClasses = MethodMetadataRepository.loadParameterClasses(parameterTypes);
            method = ReflectionUtils.findMethod(interfaceClass, (String)methodName, (Class[])parameterClasses);
            if (method == null) {
                logger.warn("Current Redis consumer Redis command interface (class name: {}) in the method ({}), command method search end!", (Object)interfaceNme, (Object)RedisCommandsUtils.buildCommandMethodId(interfaceNme, methodName, parameterTypes));
                return null;
            }
        }
        return method;
    }

    private static Class[] loadParameterClasses(String[] parameterTypes) {
        int parameterCount = parameterTypes.length;
        Class[] parameterClasses = new Class[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            Class parameterClass;
            String parameterType = parameterTypes[i];
            parameterClasses[i] = parameterClass = MethodMetadataRepository.loadClass(parameterType);
        }
        return parameterClasses;
    }

    private static Class loadClass(String className) {
        Class type = null;
        try {
            type = org.springframework.util.ClassUtils.forName((String)className, null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return type;
    }

    public static Method getWriteCommandMethod(String interfaceName, String methodName, String ... parameterTypes) {
        String id = RedisCommandsUtils.buildCommandMethodId(interfaceName, methodName, parameterTypes);
        return writeCommandMethodsCache.get(id);
    }

    public static Set<Method> getWriteCommandMethods() {
        return writeCommandMethodsMetadata.keySet();
    }

    public static Class<?> getRedisCommandsInterfaceClass(String interfaceName) {
        return redisCommandInterfacesCache.get(interfaceName);
    }

    public static Function<RedisConnection, Object> getRedisCommandBindingFunction(String interfaceName) {
        return redisCommandBindings.getOrDefault(interfaceName, redisConnection -> redisConnection);
    }

    private static void initRedisMethodsAccessible() {
        MethodMetadataRepository.initRedisMethodsAccessible(RedisConnection.class);
        List allInterfaces = ClassUtils.getAllInterfaces(RedisConnection.class);
        for (Class interfaceClass : allInterfaces) {
            MethodMetadataRepository.initRedisMethodsAccessible(interfaceClass);
        }
    }

    private static void initRedisMethodsAccessible(Class<?> interfaceClass) {
        for (Method method : interfaceClass.getMethods()) {
            if (method.isAccessible()) continue;
            method.setAccessible(true);
        }
    }

    private static void initRedisCommandsInterfaces() {
        MethodMetadataRepository.initRedisCommandsInterfacesCache();
        MethodMetadataRepository.initRedisCommandBindings();
    }

    private static void initRedisCommandsInterfacesCache() {
        Class<?>[] interfaces;
        for (Class<?> interfaceClass : interfaces = RedisCommands.class.getInterfaces()) {
            redisCommandInterfacesCache.put(interfaceClass.getName(), interfaceClass);
        }
    }

    private static void initRedisCommandBindings() {
        Class<RedisConnection> redisConnectionClass = RedisConnection.class;
        for (Map.Entry<String, Class<?>> entry : redisCommandInterfacesCache.entrySet()) {
            String interfaceName = entry.getKey();
            Class<?> interfaceClass = entry.getValue();
            ReflectionUtils.doWithMethods(redisConnectionClass, method -> {
                redisCommandBindings.put(interfaceName, redisConnection -> ReflectionUtils.invokeMethod((Method)method, (Object)redisConnection));
                logger.debug("Redis command interface {} Bind RedisConnection command object method {}", (Object)interfaceName, (Object)method);
            }, method -> interfaceClass.equals(method.getReturnType()) && method.getParameterCount() < 1);
        }
    }

    private static void initWriteCommandMethods() {
        MethodMetadataRepository.loadWriteCommandMethods();
        MethodMetadataRepository.initRedisKeyCommandsWriteCommandMethods();
        MethodMetadataRepository.initRedisStringCommandsWriteCommandMethods();
        MethodMetadataRepository.initRedisListCommandsWriteCommandMethods();
        MethodMetadataRepository.initRedisSetCommandsWriteCommandMethods();
        MethodMetadataRepository.initRedisZSetCommandsWriteCommandMethods();
        MethodMetadataRepository.initRedisHashCommandsWriteCommandMethods();
        MethodMetadataRepository.initRedisScriptingCommandsWriteCommandMethods();
        MethodMetadataRepository.initRedisGeoCommandsWriteCommandMethods();
        MethodMetadataRepository.initRedisHyperLogLogCommandsWriteCommandMethods();
    }

    private static void loadWriteCommandMethods() {
        RedisMetadata redisMetadata = MethodMetadataRepository.redisMetadata;
        for (MethodMetadata methodMetadata : redisMetadata.getMethods()) {
            if (!methodMetadata.isWrite()) continue;
            String interfaceName = methodMetadata.getInterfaceName();
            Class declaredClass = MethodMetadataRepository.loadClass(interfaceName);
            String methodName = methodMetadata.getMethodName();
            Class[] parameterTypes = MethodMetadataRepository.loadParameterClasses(methodMetadata.getParameterTypes());
            MethodMetadataRepository.initWriteCommandMethod(declaredClass, methodName, parameterTypes);
        }
    }

    private static void initRedisKeyCommandsWriteCommandMethods() {
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "del", byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "unlink", byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "touch", byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "rename", byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "renameNX", byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "expire", byte[].class, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "pExpire", byte[].class, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "expireAt", byte[].class, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "pExpireAt", byte[].class, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "persist", byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "move", byte[].class, Integer.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "ttl", byte[].class, TimeUnit.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "pTtl", byte[].class, TimeUnit.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "sort", byte[].class, SortParameters.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "sort", byte[].class, SortParameters.class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "restore", byte[].class, Long.TYPE, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisKeyCommands.class, "restore", byte[].class, Long.TYPE, byte[].class, Boolean.TYPE);
    }

    private static void initRedisStringCommandsWriteCommandMethods() {
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "set", byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "set", byte[].class, byte[].class, Expiration.class, RedisStringCommands.SetOption.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "setNX", byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "setEx", byte[].class, Long.TYPE, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "pSetEx", byte[].class, Long.TYPE, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "mSet", Map.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "mSetNX", Map.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "incr", byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "incrBy", byte[].class, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "incrBy", byte[].class, Double.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "decr", byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "decrBy", byte[].class, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "append", byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "setRange", byte[].class, byte[].class, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisStringCommands.class, "setBit", byte[].class, Long.TYPE, Boolean.TYPE);
    }

    private static void initRedisListCommandsWriteCommandMethods() {
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "rPush", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "lPush", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "rPushX", byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "lPushX", byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "lTrim", byte[].class, Long.TYPE, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "lInsert", byte[].class, RedisListCommands.Position.class, byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "lSet", byte[].class, Long.TYPE, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "lRem", byte[].class, Long.TYPE, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "lPop", byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "rPop", byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "bLPop", Integer.TYPE, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "bRPop", Integer.TYPE, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "rPopLPush", byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisListCommands.class, "bRPopLPush", Integer.TYPE, byte[].class, byte[].class);
    }

    private static void initRedisSetCommandsWriteCommandMethods() {
        MethodMetadataRepository.initWriteCommandMethod(RedisSetCommands.class, "sAdd", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisSetCommands.class, "sRem", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisSetCommands.class, "sPop", byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisSetCommands.class, "sPop", byte[].class, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisSetCommands.class, "sMove", byte[].class, byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisSetCommands.class, "sInterStore", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisSetCommands.class, "sUnionStore", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisSetCommands.class, "sDiffStore", byte[].class, byte[][].class);
    }

    private static void initRedisZSetCommandsWriteCommandMethods() {
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zAdd", byte[].class, Double.TYPE, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zAdd", byte[].class, Set.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zRem", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zIncrBy", byte[].class, Double.TYPE, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zRemRange", byte[].class, Long.TYPE, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zRemRangeByScore", byte[].class, RedisZSetCommands.Range.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zRemRangeByScore", byte[].class, Double.TYPE, Double.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zUnionStore", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zUnionStore", byte[].class, RedisZSetCommands.Aggregate.class, int[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zInterStore", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zInterStore", byte[].class, RedisZSetCommands.Aggregate.class, int[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisZSetCommands.class, "zInterStore", byte[].class, RedisZSetCommands.Aggregate.class, RedisZSetCommands.Weights.class, byte[][].class);
    }

    private static void initRedisHashCommandsWriteCommandMethods() {
        MethodMetadataRepository.initWriteCommandMethod(RedisHashCommands.class, "hSet", byte[].class, byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisHashCommands.class, "hSetNX", byte[].class, byte[].class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisHashCommands.class, "hMSet", byte[].class, Map.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisHashCommands.class, "hIncrBy", byte[].class, byte[].class, Long.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisHashCommands.class, "hIncrBy", byte[].class, byte[].class, Double.TYPE);
        MethodMetadataRepository.initWriteCommandMethod(RedisHashCommands.class, "hDel", byte[].class, byte[][].class);
    }

    private static void initRedisScriptingCommandsWriteCommandMethods() {
        MethodMetadataRepository.initWriteCommandMethod(RedisScriptingCommands.class, "scriptLoad", byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisScriptingCommands.class, "eval", byte[].class, ReturnType.class, Integer.TYPE, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisScriptingCommands.class, "evalSha", String.class, ReturnType.class, Integer.TYPE, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisScriptingCommands.class, "evalSha", byte[].class, ReturnType.class, Integer.TYPE, byte[][].class);
    }

    private static void initRedisGeoCommandsWriteCommandMethods() {
        MethodMetadataRepository.initWriteCommandMethod(RedisGeoCommands.class, "geoAdd", byte[].class, Point.class, byte[].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisGeoCommands.class, "geoAdd", byte[].class, RedisGeoCommands.GeoLocation.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisGeoCommands.class, "geoAdd", byte[].class, Map.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisGeoCommands.class, "geoAdd", byte[].class, Iterable.class);
        MethodMetadataRepository.initWriteCommandMethod(RedisGeoCommands.class, "geoRemove", byte[].class, byte[][].class);
    }

    private static void initRedisHyperLogLogCommandsWriteCommandMethods() {
        MethodMetadataRepository.initWriteCommandMethod(RedisHyperLogLogCommands.class, "pfAdd", byte[].class, byte[][].class);
        MethodMetadataRepository.initWriteCommandMethod(RedisHyperLogLogCommands.class, "pfMerge", byte[].class, byte[][].class);
    }

    private static void initWriteCommandMethod(Class<?> declaredClass, String methodName, Class<?> ... parameterTypes) {
        block4: {
            try {
                logger.debug("Initializes the write command method[Declared Class: {} , Method: {}, Parameter types: {}]...", new Object[]{declaredClass.getName(), methodName, Arrays.toString(parameterTypes)});
                Method method = ReflectionUtils.findMethod(declaredClass, (String)methodName, (Class[])parameterTypes);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                if (MethodMetadataRepository.initWriteCommandMethodMethod(method, parameterTypes)) {
                    MethodMetadataRepository.initWriteCommandMethodCache(declaredClass, method, parameterTypes);
                }
            }
            catch (Throwable e) {
                logger.error("Unable to initialize write command method[Declared Class: {}, Method: {}, Parameter types: {}], Reason: {}", new Object[]{declaredClass.getName(), methodName, Arrays.toString(parameterTypes), e.getMessage()});
                if (!RedisConstants.FAIL_FAST_ENABLED) break block4;
                logger.error("Fail-Fast mode is activated and an exception is about to be thrown. You can disable Fail-Fast mode with the JVM startup parameter -D{}=false", (Object)"microsphere.redis.fail-fast");
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static boolean initWriteCommandMethodMethod(Method method, Class<?>[] parameterTypes) {
        if (writeCommandMethodsMetadata.containsKey(method)) {
            return false;
        }
        List<ParameterMetadata> parameterMetadataList = RedisCommandsUtils.buildParameterMetadata(method, parameterTypes);
        writeCommandMethodsMetadata.put(method, parameterMetadataList);
        logger.debug("Initializing write command method metadata information successfully, Method: {}, parameter Write Command Method metadata information: {}", (Object)method.getName(), parameterMetadataList);
        return true;
    }

    private static void initWriteCommandMethodCache(Class<?> declaredClass, Method method, Class<?>[] parameterTypes) {
        String id = RedisCommandsUtils.buildCommandMethodId(declaredClass.getName(), method.getName(), parameterTypes);
        if (writeCommandMethodsCache.putIfAbsent(id, method) == null) {
            logger.debug("Cache write command method[id: {}, Method: {}]", (Object)id, (Object)method);
        } else {
            logger.warn("write command method[id: {}, Method: {}] is cached", (Object)id, (Object)method);
        }
    }

    static {
        MethodMetadataRepository.init();
    }
}

