/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.metadata;

import io.microsphere.redis.spring.metadata.ParameterMetadata;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.springframework.lang.Nullable;

public class Parameter {
    private final Object value;
    private final ParameterMetadata metadata;
    @Nullable
    private byte[] rawValue;

    public Parameter(Object value, ParameterMetadata metadata) {
        this.value = value;
        this.metadata = metadata;
    }

    public Object getValue() {
        return this.value;
    }

    public ParameterMetadata getMetadata() {
        return this.metadata;
    }

    @Nullable
    public byte[] getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(@Nullable byte[] rawValue) {
        this.rawValue = rawValue;
    }

    public int getParameterIndex() {
        return this.metadata.getParameterIndex();
    }

    public String getParameterType() {
        return this.metadata.getParameterType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (!Objects.equals(this.value, parameter.value)) {
            return false;
        }
        if (!Objects.equals(this.metadata, parameter.metadata)) {
            return false;
        }
        return Arrays.equals(this.rawValue, parameter.rawValue);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.rawValue);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", Parameter.class.getSimpleName() + "[", "]").add("value=" + this.value).add("metadata=" + this.metadata).add("rawValue=" + Arrays.toString(this.rawValue)).toString();
    }
}

