/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.metadata;

import io.microsphere.redis.spring.event.RedisCommandEvent;
import io.microsphere.redis.spring.metadata.MethodMetadata;
import io.microsphere.redis.spring.metadata.ParameterMetadata;
import io.microsphere.redis.spring.metadata.RedisMetadata;
import io.microsphere.redis.spring.util.RedisCommandsUtils;
import io.microsphere.redis.spring.util.RedisConstants;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.redis.connection.RedisCommands;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.util.ReflectionUtils;
import org.yaml.snakeyaml.Yaml;

public class RedisMetadataRepository {
    private static final Logger logger = LoggerFactory.getLogger(RedisMetadataRepository.class);
    static final Map<String, Class<?>> redisCommandInterfacesCache = RedisMetadataRepository.initRedisCommandInterfacesCache();
    static final Map<String, Method> redisCommandMethodsCache = RedisMetadataRepository.initRedisCommandMethodsCache();
    static final Map<String, Function<RedisConnection, Object>> redisCommandBindings = RedisMetadataRepository.initRedisCommandBindings();
    static final Map<Method, List<ParameterMetadata>> writeCommandMethodsMetadata = new HashMap<Method, List<ParameterMetadata>>(256);
    static final Map<String, Method> writeCommandMethodsCache = new HashMap<String, Method>(256);
    static final Map<Object, Object> methodMetadataCache = RedisMetadataRepository.initMethodMetadataCache();

    private static Map<String, Class<?>> initRedisCommandInterfacesCache() {
        List redisCommandInterfaceClasses = ClassUtils.getAllInterfaces(RedisCommands.class);
        int size = redisCommandInterfaceClasses.size();
        HashMap<String, Class> redisCommandInterfacesCache = new HashMap<String, Class>(size);
        for (int i = 0; i < size; ++i) {
            Class redisCommandInterfaceClass = (Class)redisCommandInterfaceClasses.get(i);
            String interfaceName = redisCommandInterfaceClass.getName();
            redisCommandInterfacesCache.put(interfaceName, redisCommandInterfaceClass);
            logger.debug("Caches the Redis Command Interface : {}", (Object)interfaceName);
        }
        return Collections.unmodifiableMap(redisCommandInterfacesCache);
    }

    private static Map<String, Method> initRedisCommandMethodsCache() {
        Collection<Class<?>> redisCommandInterfaceClasses = redisCommandInterfacesCache.values();
        HashMap<String, Method> redisCommandMethodsCache = new HashMap<String, Method>(512);
        for (Class<?> redisCommandInterfaceClass : redisCommandInterfaceClasses) {
            Method[] methods;
            for (Method method : methods = redisCommandInterfaceClass.getMethods()) {
                String methodId = RedisCommandsUtils.buildCommandMethodId(method);
                redisCommandMethodsCache.put(methodId, method);
                RedisMetadataRepository.setAccessible(method);
                logger.debug("Caches the Redis Command Method : {}", (Object)methodId);
            }
        }
        return Collections.unmodifiableMap(redisCommandMethodsCache);
    }

    private static Map<String, Function<RedisConnection, Object>> initRedisCommandBindings() {
        Class<RedisConnection> redisCommandInterfaceClass = RedisConnection.class;
        Method[] redisCommandMethods = redisCommandInterfaceClass.getMethods();
        int length = redisCommandMethods.length;
        HashMap<String, Function<RedisConnection, Object>> redisCommandBindings = new HashMap<String, Function<RedisConnection, Object>>(1);
        for (int i = 0; i < length; ++i) {
            Method redisCommandMethod = redisCommandMethods[i];
            RedisMetadataRepository.initRedisCommandBindings(redisCommandInterfaceClass, redisCommandMethod, redisCommandBindings);
        }
        return Collections.unmodifiableMap(redisCommandBindings);
    }

    private static Map<Object, Object> initMethodMetadataCache() {
        RedisMetadata redisMetadata = RedisMetadataRepository.loadRedisMetadata();
        List<MethodMetadata> methodMetadataList = redisMetadata.getMethods();
        int size = methodMetadataList.size();
        HashMap<Object, Object> redisMetadataCache = new HashMap<Object, Object>(size * 2);
        for (int i = 0; i < size; ++i) {
            MethodMetadata methodMetadata = methodMetadataList.get(i);
            Method redisCommandMethod = RedisMetadataRepository.getRedisCommandMethod(methodMetadata);
            if (redisCommandMethod == null) {
                logger.warn("The Redis Command Method[{}] can't be found in the artifact 'org.springframework.data:spring-data-redis'", (Object)methodMetadata);
                continue;
            }
            short id = methodMetadata.getIndex();
            if (redisMetadataCache.put(id, redisCommandMethod) == null && redisMetadataCache.put(redisCommandMethod, methodMetadata) == null) {
                if (!methodMetadata.isWrite()) continue;
                RedisMetadataRepository.initWriteCommandMethod(redisCommandMethod);
                continue;
            }
            throw new IllegalStateException("Duplicated Redis Command Method was found, " + methodMetadata);
        }
        return redisMetadataCache;
    }

    private static Method getRedisCommandMethod(MethodMetadata methodMetadata) {
        String interfaceName = methodMetadata.getInterfaceName();
        String methodName = methodMetadata.getMethodName();
        String[] parameterTypes = methodMetadata.getParameterTypes();
        return RedisMetadataRepository.getRedisCommandMethod(interfaceName, methodName, parameterTypes);
    }

    private static RedisMetadata loadRedisMetadata() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        RedisMetadata redisMetadata = new RedisMetadata();
        try {
            for (Resource resource : resolver.getResources("classpath*:/META-INF/redis-metadata.yaml")) {
                redisMetadata.merge(RedisMetadataRepository.loadRedisMetadata(resource));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return redisMetadata;
    }

    private static RedisMetadata loadRedisMetadata(Resource resource) throws IOException {
        Yaml yaml = new Yaml();
        RedisMetadata redisMetadata = (RedisMetadata)yaml.loadAs(resource.getInputStream(), RedisMetadata.class);
        return redisMetadata;
    }

    public static Short findMethodIndex(Method redisCommandMethod) {
        MethodMetadata methodMetadata = (MethodMetadata)methodMetadataCache.get(redisCommandMethod);
        return methodMetadata == null ? null : Short.valueOf(methodMetadata.getIndex());
    }

    public static Method findRedisCommandMethod(short methodIndex) {
        Method redisCommandMethod = (Method)methodMetadataCache.get(methodIndex);
        return redisCommandMethod;
    }

    public static boolean isWriteCommandMethod(Method method) {
        return writeCommandMethodsMetadata.containsKey(method);
    }

    public static List<ParameterMetadata> getWriteParameterMetadataList(Method method) {
        return writeCommandMethodsMetadata.get(method);
    }

    public static Method findWriteCommandMethod(RedisCommandEvent event) {
        return event.getMethod();
    }

    public static Method findWriteCommandMethod(String interfaceNme, String methodName, String ... parameterTypes) {
        Method method = RedisMetadataRepository.getWriteCommandMethod(interfaceNme, methodName, parameterTypes);
        if (method == null) {
            logger.warn("Redis event publishers and consumers have different apis. Please update consumer microsphere-spring-redis artifacts in time!");
            logger.debug("Redis command methods will use Java reflection to find (interface :{}, method name :{}, parameter list :{})...", new Object[]{interfaceNme, methodName, Arrays.toString(parameterTypes)});
            Class<?> redisCommandInterfaceClass = RedisMetadataRepository.getRedisCommandInterfaceClass(interfaceNme);
            if (redisCommandInterfaceClass == null) {
                logger.warn("The current Redis consumer cannot find Redis command interface: {}. Please confirm whether the spring-data artifacts API is compatible.", (Object)interfaceNme);
                return null;
            }
            Class[] parameterClasses = RedisCommandsUtils.loadParameterClasses(parameterTypes);
            method = ReflectionUtils.findMethod(redisCommandInterfaceClass, (String)methodName, (Class[])parameterClasses);
            if (method == null) {
                logger.warn("Current Redis consumer Redis command interface (class name: {}) in the method ({}), command method search end!", (Object)interfaceNme, (Object)RedisCommandsUtils.buildCommandMethodId(interfaceNme, methodName, parameterTypes));
                return null;
            }
        }
        return method;
    }

    public static Method getWriteCommandMethod(String interfaceName, String methodName, String ... parameterTypes) {
        String id = RedisCommandsUtils.buildCommandMethodId(interfaceName, methodName, parameterTypes);
        return writeCommandMethodsCache.get(id);
    }

    public static Set<Method> getWriteCommandMethods() {
        return writeCommandMethodsMetadata.keySet();
    }

    public static Class<?> getRedisCommandInterfaceClass(String interfaceName) {
        return redisCommandInterfacesCache.get(interfaceName);
    }

    public static Function<RedisConnection, Object> getRedisCommandBindingFunction(String interfaceName) {
        return redisCommandBindings.getOrDefault(interfaceName, redisConnection -> redisConnection);
    }

    public static Method getRedisCommandMethod(String interfaceName, String methodName, String ... parameterTypes) {
        String methodId = RedisCommandsUtils.buildCommandMethodId(interfaceName, methodName, parameterTypes);
        return redisCommandMethodsCache.get(methodId);
    }

    private static void setAccessible(AccessibleObject accessible) {
        if (!accessible.isAccessible()) {
            accessible.setAccessible(true);
        }
    }

    private static void initRedisCommandBindings(Class<?> redisCommandInterfaceClass, Method redisCommandMethod, Map<String, Function<RedisConnection, Object>> redisCommandBindings) {
        Class<?> returnType = redisCommandMethod.getReturnType();
        if (redisCommandInterfaceClass.equals(returnType) && redisCommandMethod.getParameterCount() < 1) {
            String interfaceName = redisCommandInterfaceClass.getName();
            redisCommandBindings.put(interfaceName, redisConnection -> ReflectionUtils.invokeMethod((Method)redisCommandMethod, (Object)redisConnection));
            logger.debug("Redis command interface {} Bind RedisConnection command object method {}", (Object)interfaceName, (Object)redisCommandMethod);
        }
    }

    private static void initWriteCommandMethod(Method method) {
        block4: {
            try {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                if (RedisMetadataRepository.initWriteCommandMethodParameterMetadata(method, parameterTypes)) {
                    RedisMetadataRepository.initWriteCommandMethodCache(method, parameterTypes);
                }
            }
            catch (Throwable e) {
                logger.error("Unable to initialize write command method[{}], Reason: {}", (Object)method, (Object)e.getMessage());
                if (!RedisConstants.FAIL_FAST_ENABLED) break block4;
                logger.error("Fail-Fast mode is activated and an exception is about to be thrown. You can disable Fail-Fast mode with the JVM startup parameter -D{}=false", (Object)"microsphere.redis.fail-fast");
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static boolean initWriteCommandMethodParameterMetadata(Method method, Class<?>[] parameterTypes) {
        if (writeCommandMethodsMetadata.containsKey(method)) {
            return false;
        }
        List<ParameterMetadata> parameterMetadataList = RedisCommandsUtils.buildParameterMetadata(method, parameterTypes);
        writeCommandMethodsMetadata.put(method, parameterMetadataList);
        logger.debug("Caches the Redis Write Command Method[{}] Parameter Metadata : {}", (Object)method, parameterMetadataList);
        return true;
    }

    private static void initWriteCommandMethodCache(Method method, Class<?>[] parameterTypes) {
        Class<?> declaredClass = method.getDeclaringClass();
        String id = RedisCommandsUtils.buildCommandMethodId(declaredClass.getName(), method.getName(), parameterTypes);
        if (writeCommandMethodsCache.putIfAbsent(id, method) == null) {
            logger.debug("Caches the Redis Write Command Method : {}", (Object)id);
        } else {
            logger.warn("The Redis Write Command Method[{}] was cached", (Object)id, (Object)method);
        }
    }
}

