/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import org.springframework.core.ResolvableType;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public abstract class AbstractSerializer<T>
implements RedisSerializer<T> {
    public static final int UNBOUND_BYTES_LENGTH = -1;
    public static final int BOOLEAN_BYTES_LENGTH = 1;
    public static final int BYTE_BYTES_LENGTH = 1;
    public static final int SHORT_BYTES_LENGTH = 2;
    public static final int INTEGER_BYTES_LENGTH = 4;
    public static final int FLOAT_BYTES_LENGTH = 4;
    public static final int LONG_BYTES_LENGTH = 8;
    public static final int DOUBLE_BYTES_LENGTH = 8;
    private final ResolvableType type = this.resolvableType();
    private final Class<T> targetType = this.type.resolve();
    private final int bytesLength = this.calcBytesLength();

    public final byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return null;
        }
        return this.doSerialize(t);
    }

    public final T deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null) {
            return null;
        }
        if (this.bytesLength != -1 && bytes.length != this.getBytesLength()) {
            return null;
        }
        return this.doDeserialize(bytes);
    }

    public final Class<T> getTargetType() {
        return this.targetType;
    }

    public ResolvableType getParameterizedType() {
        return this.type;
    }

    public Class<T> getParameterizedClass() {
        return this.getTargetType();
    }

    public int getBytesLength() {
        return this.bytesLength;
    }

    protected int calcBytesLength() {
        return -1;
    }

    protected abstract byte[] doSerialize(T var1) throws SerializationException;

    protected abstract T doDeserialize(byte[] var1) throws SerializationException;

    private ResolvableType resolvableType() {
        return ResolvableType.forType(this.getClass()).as(RedisSerializer.class).getGeneric(new int[]{0});
    }
}

