/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.AbstractSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public final class BooleanSerializer
extends AbstractSerializer<Boolean> {
    public static final BooleanSerializer INSTANCE = new BooleanSerializer();
    private static final byte NULL_VALUE = -1;
    private static final byte TRUE_VALUE = 1;
    private static final byte FALSE_VALUE = 0;

    @Override
    protected int calcBytesLength() {
        return 1;
    }

    @Override
    protected byte[] doSerialize(Boolean booleanValue) throws SerializationException {
        byte byteValue = booleanValue == null ? (byte)-1 : (booleanValue != false ? (byte)1 : 0);
        byte[] bytes = new byte[]{byteValue};
        return bytes;
    }

    @Override
    protected Boolean doDeserialize(byte[] bytes) throws SerializationException {
        Boolean booleanValue = null;
        byte byteValue = bytes[0];
        switch (byteValue) {
            case -1: {
                booleanValue = null;
                break;
            }
            case 1: {
                booleanValue = Boolean.TRUE;
                break;
            }
            case 0: {
                booleanValue = Boolean.FALSE;
            }
        }
        return booleanValue;
    }
}

