/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.AbstractSerializer;
import io.microsphere.redis.spring.serializer.LongSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public final class DoubleSerializer
extends AbstractSerializer<Double> {
    private static final LongSerializer longSerializer = LongSerializer.INSTANCE;
    public static final DoubleSerializer INSTANCE = new DoubleSerializer();

    @Override
    protected int calcBytesLength() {
        return 8;
    }

    @Override
    protected byte[] doSerialize(Double aDouble) throws SerializationException {
        double doubleValue = aDouble;
        long longValue = Double.doubleToLongBits(doubleValue);
        return longSerializer.serialize(longValue);
    }

    @Override
    protected Double doDeserialize(byte[] bytes) throws SerializationException {
        long longValue = (Long)longSerializer.deserialize(bytes);
        double doubleValue = Double.longBitsToDouble(longValue);
        return doubleValue;
    }
}

