/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.IntegerSerializer;
import io.microsphere.redis.spring.serializer.ShortSerializer;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.util.ReflectionUtils;

public class EnumSerializer<E extends Enum>
implements RedisSerializer<E> {
    private static final String VALUES_METHOD_NAME = "values";
    private static final int BYTE_BYTES_LENGTH = 1;
    private static final int SHORT_BYTES_LENGTH = 2;
    private static final int INTEGER_BYTES_LENGTH = 4;
    private static final IntegerSerializer integerSerializer = IntegerSerializer.INSTANCE;
    private static final ShortSerializer shortSerializer = ShortSerializer.INSTANCE;
    private final Class<E> enumType;
    private final E[] enums;
    private final int bytesLength;

    public EnumSerializer(Class<E> enumType) {
        this.enumType = enumType;
        this.enums = this.invokeValues(this.getValuesMethod(enumType));
        this.bytesLength = this.calcBytesLength((Enum[])this.enums);
    }

    private Method getValuesMethod(Class<E> enumType) {
        Method valuesMethod = ReflectionUtils.findMethod(enumType, (String)VALUES_METHOD_NAME);
        ReflectionUtils.makeAccessible((Method)valuesMethod);
        return valuesMethod;
    }

    private int calcBytesLength(E[] enums) {
        int enumsLength = enums.length;
        if (enumsLength < 127) {
            return 1;
        }
        if (enumsLength < Short.MAX_VALUE) {
            return 2;
        }
        return 4;
    }

    private E[] invokeValues(Method valuesMethod) {
        return (Enum[])ReflectionUtils.invokeMethod((Method)valuesMethod, null);
    }

    public byte[] serialize(Enum e) throws SerializationException {
        if (e == null) {
            return null;
        }
        int ordinal = e.ordinal();
        byte[] bytes = new byte[this.bytesLength];
        switch (this.bytesLength) {
            case 1: {
                bytes[0] = (byte)ordinal;
                break;
            }
            case 2: {
                bytes = shortSerializer.serialize((short)ordinal);
                break;
            }
            case 4: {
                bytes = integerSerializer.serialize(ordinal);
            }
        }
        return bytes;
    }

    public E deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null) {
            return null;
        }
        int ordinal = 0;
        switch (this.bytesLength) {
            case 1: {
                ordinal = bytes[0];
                break;
            }
            case 2: {
                ordinal = ((Short)shortSerializer.deserialize(bytes)).shortValue();
                break;
            }
            case 4: {
                ordinal = (Integer)integerSerializer.deserialize(bytes);
            }
        }
        return this.enums[ordinal];
    }

    public Class<E> getEnumType() {
        return this.enumType;
    }

    public int getBytesLength() {
        return this.bytesLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumSerializer)) {
            return false;
        }
        EnumSerializer that = (EnumSerializer)o;
        return this.enumType.equals(that.enumType);
    }

    public int hashCode() {
        return Objects.hash(this.enumType);
    }

    public Class<?> getTargetType() {
        return this.enumType;
    }
}

