/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.AbstractSerializer;
import io.microsphere.redis.spring.serializer.EnumSerializer;
import io.microsphere.redis.spring.serializer.LongSerializer;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.SerializationException;

public class ExpirationSerializer
extends AbstractSerializer<Expiration> {
    private static final LongSerializer longSerializer = LongSerializer.INSTANCE;
    private static final EnumSerializer<TimeUnit> timeUnitEnumSerializer = new EnumSerializer<TimeUnit>(TimeUnit.class);
    private static final int expirationTimeBytesLength = longSerializer.getBytesLength();
    private static final int timeUnitBytesLength = timeUnitEnumSerializer.getBytesLength();
    public static final ExpirationSerializer INSTANCE = new ExpirationSerializer();

    @Override
    protected int calcBytesLength() {
        return expirationTimeBytesLength + timeUnitBytesLength;
    }

    @Override
    protected byte[] doSerialize(Expiration expiration) throws SerializationException {
        int i;
        int bytesLength = this.getBytesLength();
        long expirationTime = expiration.getExpirationTime();
        byte[] expirationTimeBytes = longSerializer.serialize(expirationTime);
        byte[] bytes = new byte[bytesLength];
        for (i = 0; i < expirationTimeBytesLength; ++i) {
            bytes[i] = expirationTimeBytes[i];
        }
        TimeUnit timeUnit = expiration.getTimeUnit();
        byte ordinal = (byte)timeUnit.ordinal();
        while (i < bytesLength) {
            bytes[i] = ordinal;
            ++i;
        }
        return bytes;
    }

    @Override
    protected Expiration doDeserialize(byte[] bytes) throws SerializationException {
        int i;
        int expirationTimeBytesLength = ExpirationSerializer.expirationTimeBytesLength;
        int timeUnitBytesLength = ExpirationSerializer.timeUnitBytesLength;
        int bytesLength = this.getBytesLength();
        byte[] expirationTimeBytes = new byte[expirationTimeBytesLength];
        for (i = 0; i < expirationTimeBytesLength; ++i) {
            expirationTimeBytes[i] = bytes[i];
        }
        byte[] timeUnitBytes = new byte[timeUnitBytesLength];
        for (int j = 0; j < timeUnitBytesLength && i < bytesLength; ++j, ++i) {
            timeUnitBytes[j] = bytes[i];
        }
        long expirationTime = (Long)longSerializer.deserialize(expirationTimeBytes);
        TimeUnit timeUnit = (TimeUnit)((Object)timeUnitEnumSerializer.deserialize(timeUnitBytes));
        return Expiration.from((long)expirationTime, (TimeUnit)timeUnit);
    }
}

