/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.AbstractSerializer;
import io.microsphere.redis.spring.serializer.PointSerializer;
import io.microsphere.redis.spring.serializer.Serializers;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.serializer.SerializationException;

public class GeoLocationSerializer
extends AbstractSerializer<RedisGeoCommands.GeoLocation> {
    private static final PointSerializer pointSerializer = PointSerializer.INSTANCE;
    public static final GeoLocationSerializer INSTANCE = new GeoLocationSerializer();
    private static final String NAME_KEY = "n";
    private static final String POINT_KEY = "p";

    @Override
    protected byte[] doSerialize(RedisGeoCommands.GeoLocation geoLocation) throws SerializationException {
        Object name = geoLocation.getName();
        Point point = geoLocation.getPoint();
        HashMap<String, byte[]> data = new HashMap<String, byte[]>(2);
        byte[] nameBytes = Serializers.defaultSerialize(name);
        byte[] pointBytes = pointSerializer.serialize(point);
        data.put(NAME_KEY, nameBytes);
        data.put(POINT_KEY, pointBytes);
        return Serializers.defaultSerialize(data);
    }

    @Override
    protected RedisGeoCommands.GeoLocation doDeserialize(byte[] bytes) throws SerializationException {
        Map data = Serializers.deserialize(bytes, Map.class);
        byte[] nameBytes = (byte[])data.get(NAME_KEY);
        byte[] pointBytes = (byte[])data.get(POINT_KEY);
        Object object = Serializers.deserialize(nameBytes, Object.class);
        Point point = (Point)pointSerializer.deserialize(pointBytes);
        return new RedisGeoCommands.GeoLocation(object, point);
    }
}

