/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.beans.DelegatingWrapper;
import io.microsphere.redis.spring.util.ValueHolder;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.lang.Nullable;

public class HoldingValueRedisSerializerWrapper<T>
implements RedisSerializer<T>,
DelegatingWrapper {
    private final RedisSerializer<T> delegate;

    public HoldingValueRedisSerializerWrapper(RedisSerializer<T> delegate) {
        this.delegate = delegate;
    }

    @Nullable
    public byte[] serialize(T value) throws SerializationException {
        ValueHolder valueHolder = ValueHolder.get();
        byte[] rawValue = valueHolder.getRawValue(value);
        if (rawValue == null) {
            rawValue = this.delegate.serialize(value);
            valueHolder.set(value, rawValue);
        }
        return rawValue;
    }

    @Nullable
    public T deserialize(byte[] bytes) throws SerializationException {
        ValueHolder valueHolder = ValueHolder.get();
        Object value = valueHolder.getValue(bytes);
        if (value == null) {
            value = this.delegate.deserialize(bytes);
            valueHolder.set(value, bytes);
        }
        return (T)value;
    }

    public boolean canSerialize(Class type) {
        return this.delegate.canSerialize(type);
    }

    public Class<?> getTargetType() {
        return this.delegate.getTargetType();
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    public static <T> RedisSerializer<T> wrap(RedisSerializer<T> redisSerializer) {
        if (redisSerializer == null) {
            return null;
        }
        return new HoldingValueRedisSerializerWrapper<T>(redisSerializer);
    }

    public static void wrap(RedisTemplate redisTemplate) {
        redisTemplate.setDefaultSerializer(HoldingValueRedisSerializerWrapper.wrap(redisTemplate.getDefaultSerializer()));
        redisTemplate.setKeySerializer(HoldingValueRedisSerializerWrapper.wrap(redisTemplate.getKeySerializer()));
        redisTemplate.setValueSerializer(HoldingValueRedisSerializerWrapper.wrap(redisTemplate.getValueSerializer()));
        redisTemplate.setHashKeySerializer(HoldingValueRedisSerializerWrapper.wrap(redisTemplate.getHashKeySerializer()));
        redisTemplate.setHashValueSerializer(HoldingValueRedisSerializerWrapper.wrap(redisTemplate.getHashValueSerializer()));
    }
}

