/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.AbstractSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class IntegerSerializer
extends AbstractSerializer<Integer> {
    public static final IntegerSerializer INSTANCE = new IntegerSerializer();

    @Override
    protected int calcBytesLength() {
        return 4;
    }

    @Override
    protected byte[] doSerialize(Integer integer) throws SerializationException {
        int intValue = integer;
        byte[] bytes = new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue >> 0 & 0xFF)};
        return bytes;
    }

    @Override
    protected Integer doDeserialize(byte[] bytes) throws SerializationException {
        int intValue = (0xFF & bytes[0]) << 24 | (0xFF & bytes[1]) << 16 | (0xFF & bytes[2]) << 8 | (0xFF & bytes[3]) << 0;
        return intValue;
    }
}

