/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.AbstractSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public final class LongSerializer
extends AbstractSerializer<Long> {
    public static final LongSerializer INSTANCE = new LongSerializer();

    @Override
    protected int calcBytesLength() {
        return 8;
    }

    @Override
    protected byte[] doSerialize(Long aLong) throws SerializationException {
        long longValue = aLong;
        byte[] bytes = new byte[]{(byte)longValue, (byte)(longValue >> 8), (byte)(longValue >> 16), (byte)(longValue >> 24), (byte)(longValue >> 32), (byte)(longValue >> 40), (byte)(longValue >> 48), (byte)(longValue >> 56)};
        return bytes;
    }

    @Override
    protected Long doDeserialize(byte[] bytes) throws SerializationException {
        long longValue = (long)bytes[7] << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[0] & 0xFFL;
        return longValue;
    }
}

