/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.event.RedisCommandEvent;
import io.microsphere.redis.spring.metadata.RedisMetadataRepository;
import io.microsphere.redis.spring.serializer.AbstractSerializer;
import io.microsphere.redis.spring.serializer.Serializers;
import io.microsphere.redis.spring.serializer.ShortSerializer;
import io.microsphere.redis.spring.util.RedisCommandsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.util.FastByteArrayOutputStream;

public class RedisCommandEventSerializer
extends AbstractSerializer<RedisCommandEvent> {
    public static final byte VERSION_DEFAULT = 0;
    public static final byte VERSION_V1 = 1;
    private static final RedisSerializer<RedisCommandEvent> delegate = RedisCommandEventSerializer.findDelegate();

    private static RedisSerializer<RedisCommandEvent> findDelegate() {
        return RedisCommandEventSerializer.findDelegate((byte)0);
    }

    private static RedisSerializer<RedisCommandEvent> findDelegate(byte version) {
        return VersionedRedisSerializer.valueOf(version);
    }

    @Override
    protected byte[] doSerialize(RedisCommandEvent redisCommandEvent) throws SerializationException {
        byte version = redisCommandEvent.getSerializationVersion();
        RedisSerializer<RedisCommandEvent> delegate = RedisCommandEventSerializer.findDelegate(version);
        return delegate.serialize((Object)redisCommandEvent);
    }

    @Override
    protected RedisCommandEvent doDeserialize(byte[] bytes) throws SerializationException {
        byte version = bytes[0];
        RedisSerializer<RedisCommandEvent> delegate = RedisCommandEventSerializer.findDelegate(version);
        return (RedisCommandEvent)((Object)delegate.deserialize(bytes));
    }

    static enum VersionedRedisSerializer implements RedisSerializer<RedisCommandEvent>
    {
        DEFAULT(0){

            @Override
            protected void writeMethodMetadata(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
                this.writeInterfaceName(redisCommandEvent, outputStream);
                this.writeMethodName(redisCommandEvent, outputStream);
                this.writeParameterTypes(redisCommandEvent, outputStream);
            }

            private void writeInterfaceName(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
                String simpleName = RedisCommandsUtils.resolveSimpleInterfaceName(redisCommandEvent.getInterfaceName());
                this.writeString(simpleName, outputStream);
            }

            private void writeMethodName(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
                this.writeString(redisCommandEvent.getMethodName(), outputStream);
            }

            private void writeParameterTypes(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
                Class<?>[] parameterTypes = redisCommandEvent.getParameterTypes();
                int parameterCount = redisCommandEvent.getParameterCount();
                outputStream.write(parameterCount);
                for (Class<?> parameterType : parameterTypes) {
                    this.writeString(parameterType.getName(), outputStream);
                }
            }

            @Override
            protected void readMethodMetadata(InputStream inputStream, RedisCommandEvent.Builder builder) throws IOException {
                this.readMethod(inputStream, builder);
            }

            private void readMethod(InputStream inputStream, RedisCommandEvent.Builder builder) throws IOException {
                String interfaceName = this.readInterfaceName(inputStream);
                String methodName = this.readMethodName(inputStream);
                int parameterCount = inputStream.read();
                String[] parameterTypes = this.readParameterTypes(inputStream, parameterCount);
                Method method = RedisMetadataRepository.findWriteCommandMethod(interfaceName, methodName, parameterTypes);
                builder.method(method);
            }

            private String readInterfaceName(InputStream inputStream) throws IOException {
                String interfaceName = this.readString(inputStream);
                return RedisCommandsUtils.resolveInterfaceName(interfaceName);
            }

            private String readMethodName(InputStream inputStream) throws IOException {
                return this.readString(inputStream);
            }

            private String[] readParameterTypes(InputStream inputStream, int parameterCount) throws IOException {
                String[] parameterTypes = new String[parameterCount];
                for (int i = 0; i < parameterCount; ++i) {
                    parameterTypes[i] = this.readString(inputStream);
                }
                return parameterTypes;
            }
        }
        ,
        V1(1){
            private final ShortSerializer serializer = ShortSerializer.INSTANCE;

            @Override
            protected void writeMethodMetadata(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
                Method redisCommandMethod = redisCommandEvent.getMethod();
                short methodIndex = RedisMetadataRepository.findMethodIndex(redisCommandMethod);
                byte[] bytes = this.serializer.serialize(methodIndex);
                outputStream.write(bytes);
            }

            @Override
            protected void readMethodMetadata(InputStream inputStream, RedisCommandEvent.Builder builder) throws IOException {
                int bytesLength = this.serializer.getBytesLength();
                byte[] bytes = new byte[bytesLength];
                inputStream.read(bytes);
                short methodIndex = (Short)this.serializer.deserialize(bytes);
                Method redisCommandMethod = RedisMetadataRepository.findRedisCommandMethod(methodIndex);
                builder.method(redisCommandMethod);
            }
        };

        private final Charset asciiCharset = StandardCharsets.US_ASCII;
        private final byte version;

        private VersionedRedisSerializer(int version) {
            this((byte)version);
        }

        private VersionedRedisSerializer(byte version) {
            this.version = version;
        }

        public byte[] serialize(RedisCommandEvent redisCommandEvent) throws SerializationException {
            try (FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();){
                this.writeMetadata(redisCommandEvent, (OutputStream)outputStream);
                this.writeData(redisCommandEvent, (OutputStream)outputStream);
            }
            return outputStream.toByteArray();
        }

        protected void writeMetadata(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
            this.writeVersion(redisCommandEvent, outputStream);
            this.writeApplicationName(redisCommandEvent, outputStream);
            this.writeMethodMetadata(redisCommandEvent, outputStream);
        }

        protected void writeVersion(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
            outputStream.write(this.version);
        }

        protected void writeApplicationName(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
            this.writeString(redisCommandEvent.getApplicationName(), outputStream);
        }

        protected void writeMethodMetadata(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
        }

        private void writeData(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
            this.writeArguments(redisCommandEvent, outputStream);
        }

        protected void writeArguments(RedisCommandEvent redisCommandEvent, OutputStream outputStream) throws IOException {
            Object[] args = redisCommandEvent.getArgs();
            Class<?>[] parameterTypes = redisCommandEvent.getParameterTypes();
            int parameterCount = redisCommandEvent.getParameterCount();
            for (int i = 0; i < parameterCount; ++i) {
                Object arg = args[i];
                Class<?> parameterType = parameterTypes[i];
                byte[] parameter = Serializers.serialize(arg, parameterType);
                this.writeBytes(parameter, outputStream);
            }
        }

        protected void writeString(String value, OutputStream outputStream) throws IOException {
            byte[] bytes = this.getBytes(value);
            this.writeBytes(bytes, outputStream);
        }

        protected void writeBytes(byte[] bytes, OutputStream outputStream) throws IOException {
            int bytesLength = bytes.length;
            outputStream.write(bytesLength);
            outputStream.write(bytes);
        }

        public RedisCommandEvent deserialize(byte[] bytes) throws SerializationException {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes, 1, bytes.length);
            RedisCommandEvent.Builder builder = RedisCommandEvent.Builder.source("stream");
            try {
                this.readMetadata(inputStream, builder);
                this.readData(inputStream, builder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return builder.build();
        }

        protected void readMetadata(InputStream inputStream, RedisCommandEvent.Builder builder) throws IOException {
            this.readApplicationName(inputStream, builder);
            this.readMethodMetadata(inputStream, builder);
        }

        protected void readApplicationName(InputStream inputStream, RedisCommandEvent.Builder builder) throws IOException {
            String applicationName = this.readApplicationName(inputStream);
            builder.applicationName(applicationName);
        }

        protected void readMethodMetadata(InputStream inputStream, RedisCommandEvent.Builder builder) throws IOException {
        }

        protected void readData(InputStream inputStream, RedisCommandEvent.Builder builder) throws IOException {
            this.readArguments(inputStream, builder);
        }

        protected void readArguments(InputStream inputStream, RedisCommandEvent.Builder builder) throws IOException {
            Method method = builder.getMethod();
            int parameterCount = method.getParameterCount();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] args = new Object[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                byte[] rawArgument = this.readBytes(inputStream);
                Class<?> parameterType = parameterTypes[i];
                args[i] = Serializers.deserialize(rawArgument, parameterType);
            }
            builder.args(args);
        }

        protected String readApplicationName(InputStream inputStream) throws IOException {
            return this.readString(inputStream);
        }

        protected byte[] readBytes(InputStream inputStream) throws IOException {
            int length = inputStream.read();
            byte[] bytes = new byte[length];
            inputStream.read(bytes, 0, length);
            return bytes;
        }

        protected String readString(InputStream inputStream) throws IOException {
            int length = inputStream.read();
            byte[] bytes = new byte[length];
            inputStream.read(bytes, 0, length);
            return new String(bytes, this.asciiCharset);
        }

        protected byte[] getBytes(String value) {
            return value.getBytes(this.asciiCharset);
        }

        static RedisSerializer<RedisCommandEvent> valueOf(byte version) {
            if (1 == version) {
                return V1;
            }
            return DEFAULT;
        }
    }
}

