/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.event.RedisCommandEvent;
import io.microsphere.redis.spring.metadata.Parameter;
import io.microsphere.redis.spring.serializer.BooleanSerializer;
import io.microsphere.redis.spring.serializer.ByteArraySerializer;
import io.microsphere.redis.spring.serializer.DoubleSerializer;
import io.microsphere.redis.spring.serializer.EnumSerializer;
import io.microsphere.redis.spring.serializer.ExpirationSerializer;
import io.microsphere.redis.spring.serializer.GeoLocationSerializer;
import io.microsphere.redis.spring.serializer.IntegerSerializer;
import io.microsphere.redis.spring.serializer.LongSerializer;
import io.microsphere.redis.spring.serializer.PointSerializer;
import io.microsphere.redis.spring.serializer.RangeSerializer;
import io.microsphere.redis.spring.serializer.SortParametersSerializer;
import io.microsphere.redis.spring.serializer.WeightsSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public abstract class Serializers {
    private static final Logger logger = LoggerFactory.getLogger(Serializers.class);
    private static final ClassLoader classLoader = Serializers.class.getClassLoader();
    public static final JdkSerializationRedisSerializer defaultSerializer = new JdkSerializationRedisSerializer();
    public static final StringRedisSerializer stringSerializer = new StringRedisSerializer();
    static final Map<String, RedisSerializer<?>> typedSerializers = new HashMap(32);

    public static RedisSerializer<?> getSerializer(Object object) {
        Class<?> type = object.getClass();
        return Serializers.getSerializer(type);
    }

    public static <T> RedisSerializer<T> getSerializer(Class<?> type) {
        return type == null ? null : Serializers.getSerializer(type.getName());
    }

    public static RedisSerializer<?> getSerializer(String typeName) {
        JdkSerializationRedisSerializer serializer = typedSerializers.get(typeName);
        if (serializer == null) {
            logger.debug("RedisSerializer implementation class of type {} not found, default RedisSerializer implementation class will be used: {}", (Object)typeName, (Object)defaultSerializer.getClass().getName());
            serializer = defaultSerializer;
            typedSerializers.put(typeName, (RedisSerializer<?>)serializer);
        } else {
            logger.trace("Find the RedisSerializer implementation class of type {} : {}", (Object)typeName, (Object)serializer.getClass().getName());
        }
        return serializer;
    }

    public static byte[] serializeRawParameter(Parameter parameter) {
        byte[] rawParameterValue = parameter.getRawValue();
        if (rawParameterValue == null) {
            Object parameterValue = parameter.getValue();
            RedisSerializer<?> serializer = Serializers.getSerializer(parameter.getParameterType());
            if (serializer != null) {
                rawParameterValue = serializer.serialize(parameterValue);
                parameter.setRawValue(rawParameterValue);
            }
        }
        return rawParameterValue;
    }

    public static byte[] defaultSerialize(RedisCommandEvent event) {
        return defaultSerializer.serialize((Object)event);
    }

    public static byte[] defaultSerialize(Object object) {
        return defaultSerializer.serialize(object);
    }

    public static byte[] serialize(Object object) {
        return Serializers.serialize(object, object.getClass());
    }

    public static byte[] serialize(Object object, Class type) {
        RedisSerializer redisSerializer = Serializers.getSerializer(type);
        return redisSerializer.serialize(object);
    }

    public static Object deserialize(byte[] bytes, String parameterType) {
        RedisSerializer<?> serializer = Serializers.getSerializer(parameterType);
        if (serializer == null) {
            logger.error("Unable to deserialize the byte stream to an object of target type {}", (Object)parameterType);
            return null;
        }
        Object object = serializer.deserialize(bytes);
        return object;
    }

    public static <T> T deserialize(byte[] bytes, Class<T> type) {
        RedisSerializer<T> serializer = Serializers.getSerializer(type);
        Object object = serializer.deserialize(bytes);
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        logger.error("Unable to deserialize the byte stream to an object of target type {}", (Object)type.getName());
        return null;
    }

    private static void initializeBuiltinSerializers() {
        Serializers.initializeSimpleSerializers();
        Serializers.initializeArrayTypeSerializers();
        Serializers.initializeCollectionTypeSerializers();
        Serializers.initializeEnumerationSerializers();
        Serializers.initializeSpringDataRedisSerializers();
    }

    private static void initializeSimpleSerializers() {
        Serializers.register(Boolean.TYPE, BooleanSerializer.INSTANCE);
        Serializers.register(Boolean.class, BooleanSerializer.INSTANCE);
        Serializers.register(Integer.TYPE, IntegerSerializer.INSTANCE);
        Serializers.register(Integer.class, IntegerSerializer.INSTANCE);
        Serializers.register(Long.TYPE, LongSerializer.INSTANCE);
        Serializers.register(Long.class, LongSerializer.INSTANCE);
        Serializers.register(Double.TYPE, DoubleSerializer.INSTANCE);
        Serializers.register(Double.class, DoubleSerializer.INSTANCE);
        Serializers.register(String.class, stringSerializer);
    }

    private static void initializeCollectionTypeSerializers() {
        Serializers.register(Iterable.class, defaultSerializer);
        Serializers.register(Iterator.class, defaultSerializer);
        Serializers.register(Collection.class, defaultSerializer);
        Serializers.register(List.class, defaultSerializer);
        Serializers.register(Set.class, defaultSerializer);
        Serializers.register(Map.class, defaultSerializer);
        Serializers.register(Queue.class, defaultSerializer);
    }

    private static void initializeArrayTypeSerializers() {
        Serializers.register(byte[].class, ByteArraySerializer.INSTANCE);
        Serializers.register(int[].class, defaultSerializer);
        Serializers.register(byte[][].class, defaultSerializer);
    }

    private static void initializeEnumerationSerializers() {
        Serializers.register(TimeUnit.class, new EnumSerializer<TimeUnit>(TimeUnit.class));
    }

    private static void initializeSpringDataRedisSerializers() {
        Serializers.register(Expiration.class, ExpirationSerializer.INSTANCE);
        Serializers.register(SortParameters.class, SortParametersSerializer.INSTANCE);
        Serializers.register(RedisListCommands.Position.class, new EnumSerializer<RedisListCommands.Position>(RedisListCommands.Position.class));
        Serializers.register(RedisStringCommands.SetOption.class, new EnumSerializer<RedisStringCommands.SetOption>(RedisStringCommands.SetOption.class));
        Serializers.register(RedisZSetCommands.Range.class, RangeSerializer.INSTANCE);
        Serializers.register(RedisZSetCommands.Aggregate.class, new EnumSerializer<RedisZSetCommands.Aggregate>(RedisZSetCommands.Aggregate.class));
        Serializers.register(RedisZSetCommands.Weights.class, WeightsSerializer.INSTANCE);
        Serializers.register(ReturnType.class, new EnumSerializer<ReturnType>(ReturnType.class));
        Serializers.register(RedisGeoCommands.GeoLocation.class, GeoLocationSerializer.INSTANCE);
        Serializers.register(Point.class, PointSerializer.INSTANCE);
    }

    private static void initializeParameterizedSerializers() {
        List<RedisSerializer> serializers = Serializers.loadSerializers();
        Serializers.initializeParameterizedSerializers(serializers);
    }

    private static void initializeParameterizedSerializers(List<RedisSerializer> serializers) {
        for (RedisSerializer serializer : serializers) {
            Serializers.initializeParameterizedSerializer(serializer);
        }
    }

    private static void initializeParameterizedSerializer(RedisSerializer serializer) {
        Class parameterizedType = ResolvableType.forType(serializer.getClass()).as(RedisSerializer.class).getGeneric(new int[]{0}).resolve();
        if (parameterizedType != null) {
            Serializers.register(parameterizedType, serializer);
        } else {
            logger.warn("RedisSerializer implementation class: {} could not find parameter type", serializer.getClass());
        }
    }

    private static List<RedisSerializer> loadSerializers() {
        return SpringFactoriesLoader.loadFactories(RedisSerializer.class, (ClassLoader)classLoader);
    }

    public static void register(Class<?> type, RedisSerializer<?> serializer) {
        String typeName = type.getName();
        RedisSerializer<?> oldSerializer = typedSerializers.put(typeName, serializer);
        logger.debug("The RedisSerializer[class : '{}' , target type : '{}'] for type['{}'] was registered", new Object[]{Serializers.getTypeName(serializer), Serializers.getTypeName(serializer.getTargetType()), Serializers.getTypeName(type)});
        if (oldSerializer != null && !Objects.equals(oldSerializer, serializer)) {
            logger.warn("The RedisSerializer for type['{}'] has been replaced old [class : '{}' , target type : '{}'] -> new [class : '{}' , target type : '{}']", new Object[]{Serializers.getTypeName(type), Serializers.getTypeName(oldSerializer), Serializers.getTypeName(oldSerializer.getTargetType()), Serializers.getTypeName(serializer), Serializers.getTypeName(serializer.getTargetType())});
        }
    }

    private static String getTypeName(Object object) {
        return Serializers.getTypeName(object.getClass());
    }

    private static String getTypeName(Type type) {
        return type.getTypeName();
    }

    static {
        Serializers.initializeBuiltinSerializers();
        Serializers.initializeParameterizedSerializers();
    }
}

