/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.AbstractSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class ShortSerializer
extends AbstractSerializer<Short> {
    public static final ShortSerializer INSTANCE = new ShortSerializer();

    @Override
    protected int calcBytesLength() {
        return 2;
    }

    @Override
    protected byte[] doSerialize(Short aShort) throws SerializationException {
        short shortValue = aShort;
        byte[] bytes = new byte[]{(byte)(shortValue >>> 8), (byte)(shortValue & 0xFF)};
        return bytes;
    }

    @Override
    protected Short doDeserialize(byte[] bytes) throws SerializationException {
        return (short)(bytes[0] << 8 | bytes[1] & 0xFF);
    }
}

