/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.AbstractSerializer;
import io.microsphere.redis.spring.serializer.BooleanSerializer;
import io.microsphere.redis.spring.serializer.ByteArraySerializer;
import io.microsphere.redis.spring.serializer.EnumSerializer;
import io.microsphere.redis.spring.serializer.LongSerializer;
import io.microsphere.redis.spring.serializer.Serializers;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.redis.connection.DefaultSortParameters;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.serializer.SerializationException;

public class SortParametersSerializer
extends AbstractSerializer<SortParameters> {
    private static final String ORDER_KEY = "o";
    private static final String ALPHABETIC_KEY = "a";
    private static final String BY_PATTERN_KEY = "b";
    private static final String GET_PATTERN_KEY = "g";
    private static final String LIMIT_KEY = "l";
    private static final EnumSerializer orderEnumSerializer = new EnumSerializer<SortParameters.Order>(SortParameters.Order.class);
    private static final BooleanSerializer booleanSerializer = BooleanSerializer.INSTANCE;
    private static final ByteArraySerializer byteArraySerializer = ByteArraySerializer.INSTANCE;
    private static final RangeSerializer rangeSerializer = RangeSerializer.INSTANCE;
    public static final SortParametersSerializer INSTANCE = new SortParametersSerializer();

    @Override
    protected byte[] doSerialize(SortParameters sortParameters) throws SerializationException {
        SortParameters.Range limit;
        byte[][] getPattern;
        byte[] byPattern;
        Boolean alphabetic;
        HashMap<String, byte[]> data = new HashMap<String, byte[]>(5);
        SortParameters.Order order = sortParameters.getOrder();
        if (order != null) {
            data.put(ORDER_KEY, orderEnumSerializer.serialize((Enum)order));
        }
        if ((alphabetic = sortParameters.isAlphabetic()) != null) {
            data.put(ALPHABETIC_KEY, booleanSerializer.serialize(alphabetic));
        }
        if ((byPattern = sortParameters.getByPattern()) != null) {
            data.put(BY_PATTERN_KEY, byteArraySerializer.serialize(byPattern));
        }
        if ((getPattern = sortParameters.getGetPattern()) != null) {
            data.put(GET_PATTERN_KEY, Serializers.defaultSerialize(getPattern));
        }
        if ((limit = sortParameters.getLimit()) != null) {
            data.put(LIMIT_KEY, rangeSerializer.serialize(limit));
        }
        return Serializers.defaultSerialize(data);
    }

    @Override
    protected SortParameters doDeserialize(byte[] bytes) throws SerializationException {
        DefaultSortParameters sortParameters = new DefaultSortParameters();
        Map data = Serializers.deserialize(bytes, Map.class);
        byte[] orderBytes = (byte[])data.get(ORDER_KEY);
        sortParameters.setOrder((SortParameters.Order)orderEnumSerializer.deserialize(orderBytes));
        byte[] alphabeticBytes = (byte[])data.get(ALPHABETIC_KEY);
        sortParameters.setAlphabetic((Boolean)booleanSerializer.deserialize(alphabeticBytes));
        byte[] byPatternBytes = (byte[])data.get(BY_PATTERN_KEY);
        sortParameters.setByPattern(byteArraySerializer.deserialize(byPatternBytes));
        byte[] getPatternBytes = (byte[])data.get(GET_PATTERN_KEY);
        sortParameters.setGetPattern(Serializers.deserialize(getPatternBytes, byte[][].class));
        byte[] limitBytes = (byte[])data.get(LIMIT_KEY);
        sortParameters.setLimit((SortParameters.Range)rangeSerializer.deserialize(limitBytes));
        return sortParameters;
    }

    public static class RangeSerializer
    extends AbstractSerializer<SortParameters.Range> {
        private static final LongSerializer longSerializer = LongSerializer.INSTANCE;
        public static final RangeSerializer INSTANCE = new RangeSerializer();

        @Override
        protected int calcBytesLength() {
            return longSerializer.getBytesLength() * 2;
        }

        @Override
        protected byte[] doSerialize(SortParameters.Range range) throws SerializationException {
            int i;
            long start = range.getStart();
            long count = range.getCount();
            byte[] startBytes = longSerializer.serialize(start);
            byte[] countBytes = longSerializer.serialize(count);
            int length = startBytes.length + countBytes.length;
            byte[] bytes = new byte[length];
            int index = 0;
            for (i = 0; i < startBytes.length; ++i) {
                bytes[index++] = startBytes[i];
            }
            for (i = 0; i < countBytes.length; ++i) {
                bytes[index++] = countBytes[i];
            }
            return bytes;
        }

        @Override
        protected SortParameters.Range doDeserialize(byte[] bytes) throws SerializationException {
            int i;
            int length = bytes.length;
            int size = length / 2;
            byte[] startBytes = new byte[size];
            byte[] countBytes = new byte[size];
            int index = 0;
            for (i = 0; i < size; ++i) {
                startBytes[i] = bytes[index++];
            }
            for (i = 0; i < size; ++i) {
                countBytes[i] = bytes[index++];
            }
            long start = (Long)longSerializer.deserialize(startBytes);
            long count = (Long)longSerializer.deserialize(countBytes);
            return new SortParameters.Range(start, count);
        }
    }
}

