/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.serializer;

import io.microsphere.redis.spring.serializer.AbstractSerializer;
import io.microsphere.redis.spring.serializer.Serializers;
import java.util.List;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.serializer.SerializationException;

public class WeightsSerializer
extends AbstractSerializer<RedisZSetCommands.Weights> {
    public static final WeightsSerializer INSTANCE = new WeightsSerializer();

    @Override
    protected byte[] doSerialize(RedisZSetCommands.Weights weights) throws SerializationException {
        List doubles = weights.toList();
        return Serializers.defaultSerialize(doubles);
    }

    @Override
    protected RedisZSetCommands.Weights doDeserialize(byte[] bytes) throws SerializationException {
        List doubles = Serializers.deserialize(bytes, List.class);
        int size = doubles.size();
        double[] weights = new double[size];
        for (int i = 0; i < size; ++i) {
            weights[i] = (Double)doubles.get(i);
        }
        return RedisZSetCommands.Weights.of((double[])weights);
    }
}

