/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.util;

import io.microsphere.redis.spring.event.RedisCommandEvent;
import io.microsphere.redis.spring.metadata.Parameter;
import io.microsphere.redis.spring.metadata.ParameterMetadata;
import io.microsphere.redis.spring.metadata.RedisMetadataRepository;
import io.microsphere.redis.spring.serializer.Serializers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.util.ClassUtils;

public abstract class RedisCommandsUtils {
    private static final Logger logger = LoggerFactory.getLogger(RedisCommandsUtils.class);
    private static final String REDIS_COMMANDS_PACKAGE_NAME = "org.springframework.data.redis.connection.";
    private static final int REDIS_COMMANDS_PACKAGE_NAME_LENGTH = "org.springframework.data.redis.connection.".length();
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    public static final String REDIS_GEO_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisGeoCommands";
    public static final String REDIS_HASH_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisHashCommands";
    public static final String REDIS_HYPER_LOG_LOG_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisHyperLogLogCommands";
    public static final String REDIS_KEY_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisKeyCommands";
    public static final String REDIS_LIST_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisListCommands";
    public static final String REDIS_SET_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisSetCommands";
    public static final String REDIS_SCRIPTING_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisScriptingCommands";
    public static final String REDIS_SERVER_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisServerCommands";
    public static final String REDIS_STREAM_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisStreamCommands";
    public static final String REDIS_STRING_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisStringCommands";
    public static final String REDIS_ZSET_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisZSetCommands";
    public static final String REDIS_TX_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisTxCommands";
    public static final String REDIS_PUB_SUB_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisPubSubCommands";
    public static final String REDIS_CONNECTION_COMMANDS_INTERFACE_NAME = "org.springframework.data.redis.connection.RedisConnectionCommands";

    public static String resolveSimpleInterfaceName(String interfaceName) {
        int index = interfaceName.indexOf(REDIS_COMMANDS_PACKAGE_NAME);
        if (index == 0) {
            return interfaceName.substring(REDIS_COMMANDS_PACKAGE_NAME_LENGTH);
        }
        return interfaceName;
    }

    public static String resolveInterfaceName(String interfaceName) {
        int index = interfaceName.indexOf(46);
        if (index == -1) {
            return REDIS_COMMANDS_PACKAGE_NAME + interfaceName;
        }
        return interfaceName;
    }

    public static Object getRedisCommands(RedisConnection redisConnection, String interfaceName) {
        switch (interfaceName) {
            case "org.springframework.data.redis.connection.RedisStringCommands": {
                return redisConnection.stringCommands();
            }
            case "org.springframework.data.redis.connection.RedisHashCommands": {
                return redisConnection.hashCommands();
            }
            case "org.springframework.data.redis.connection.RedisListCommands": {
                return redisConnection.listCommands();
            }
            case "org.springframework.data.redis.connection.RedisSetCommands": {
                return redisConnection.setCommands();
            }
            case "org.springframework.data.redis.connection.RedisZSetCommands": {
                return redisConnection.zSetCommands();
            }
            case "org.springframework.data.redis.connection.RedisKeyCommands": {
                return redisConnection.keyCommands();
            }
            case "org.springframework.data.redis.connection.RedisScriptingCommands": {
                return redisConnection.scriptingCommands();
            }
            case "org.springframework.data.redis.connection.RedisGeoCommands": {
                return redisConnection.geoCommands();
            }
            case "org.springframework.data.redis.connection.RedisServerCommands": {
                return redisConnection.serverCommands();
            }
        }
        throw new UnsupportedOperationException(interfaceName);
    }

    public static String buildCommandMethodId(RedisCommandEvent event) {
        return RedisCommandsUtils.buildCommandMethodId(event.getMethod());
    }

    public static String buildCommandMethodId(Method redisCommandMethod) {
        String interfaceName = redisCommandMethod.getDeclaringClass().getName();
        String methodName = redisCommandMethod.getName();
        Class<?>[] parameterTypes = redisCommandMethod.getParameterTypes();
        return RedisCommandsUtils.buildCommandMethodId(interfaceName, methodName, parameterTypes);
    }

    public static String buildCommandMethodId(String interfaceName, String methodName, Class<?> ... parameterTypes) {
        int length = parameterTypes.length;
        String[] parameterTypeNames = new String[length];
        for (int i = 0; i < length; ++i) {
            parameterTypeNames[i] = parameterTypes[i].getName();
        }
        return RedisCommandsUtils.buildCommandMethodId(interfaceName, methodName, parameterTypeNames);
    }

    public static String buildCommandMethodId(String interfaceName, String methodName, String ... parameterTypes) {
        StringBuilder infoBuilder = new StringBuilder(interfaceName);
        infoBuilder.append(".").append(methodName);
        StringJoiner paramTypesInfo = new StringJoiner(",", "(", ")");
        for (String parameterType : parameterTypes) {
            paramTypesInfo.add(parameterType);
        }
        infoBuilder.append(paramTypesInfo);
        return infoBuilder.toString();
    }

    public static boolean initParameters(Method method, Object[] args, BiConsumer<Parameter, Integer> consumer, BiConsumer<Parameter, Integer> ... otherConsumers) {
        boolean sourceFromWriteMethod = true;
        List<ParameterMetadata> parameterMetadataList = null;
        try {
            parameterMetadataList = RedisMetadataRepository.getWriteParameterMetadataList(method);
            if (parameterMetadataList == null) {
                sourceFromWriteMethod = false;
                parameterMetadataList = RedisCommandsUtils.buildParameterMetadataList(method);
            }
            int size = parameterMetadataList.size();
            int otherConsumerCount = otherConsumers.length;
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    Object parameterValue = args[i];
                    ParameterMetadata parameterMetadata = parameterMetadataList.get(i);
                    Parameter parameter = new Parameter(parameterValue, parameterMetadata);
                    Serializers.serializeRawParameter(parameter);
                    consumer.accept(parameter, i);
                    for (int j = 0; j < otherConsumerCount; ++j) {
                        BiConsumer<Parameter, Integer> parameterConsumer = otherConsumers[j];
                        parameterConsumer.accept(parameter, i);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.error("Redis failed to initialize Redis command method parameter {}!", parameterMetadataList, (Object)e);
        }
        return sourceFromWriteMethod;
    }

    public static List<ParameterMetadata> buildParameterMetadataList(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return RedisCommandsUtils.buildParameterMetadata(method, parameterTypes);
    }

    public static List<ParameterMetadata> buildParameterMetadata(Method method, Class<?>[] parameterTypes) {
        int parameterCount = parameterTypes.length;
        String[] parameterNames = parameterNameDiscoverer.getParameterNames(method);
        ArrayList<ParameterMetadata> parameterMetadataList = new ArrayList<ParameterMetadata>(parameterCount);
        for (int i = 0; i < parameterCount; ++i) {
            String parameterType = parameterTypes[i].getName();
            String parameterName = parameterNames[i];
            ParameterMetadata parameterMetadata = new ParameterMetadata(i, parameterType, parameterName);
            parameterMetadataList.add(parameterMetadata);
            Serializers.getSerializer(parameterType);
        }
        return Collections.unmodifiableList(parameterMetadataList);
    }

    public static Class[] loadParameterClasses(String ... parameterTypes) {
        int parameterCount = parameterTypes.length;
        Class[] parameterClasses = new Class[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            Class parameterClass;
            String parameterType = parameterTypes[i];
            parameterClasses[i] = parameterClass = RedisCommandsUtils.loadClass(parameterType);
        }
        return parameterClasses;
    }

    private static Class loadClass(String className) {
        Class type = null;
        try {
            type = ClassUtils.forName((String)className, null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return type;
    }
}

