/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.redis.spring.util;

import io.microsphere.redis.spring.util.RawValue;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueHolder {
    private static final Logger logger = LoggerFactory.getLogger(ValueHolder.class);
    private static final ThreadLocal<ValueHolder> holder = ThreadLocal.withInitial(() -> new ValueHolder(4));
    private final Map<Object, Object> cache;

    public ValueHolder(int initialCapacity) {
        this.cache = new HashMap<Object, Object>(initialCapacity << 1);
    }

    public void set(Object value, byte[] rawValue) {
        RawValue rawValueObject = RawValue.of(rawValue);
        this.put(value, rawValueObject);
        this.put(rawValueObject, value);
    }

    private void put(Object key, Object value) {
        Object oldValue = this.cache.put(key, value);
        if (logger.isDebugEnabled()) {
            logger.debug("Put key[{}] and value[{}] into cache, old value : {}", new Object[]{key, value, oldValue});
        }
    }

    public Object getValue(byte[] rawValue) {
        RawValue rawValueObject = RawValue.of(rawValue);
        return this.cache.get(rawValueObject);
    }

    public byte[] getRawValue(Object value) {
        Object rawValue = this.cache.get(value);
        return rawValue instanceof RawValue ? ((RawValue)rawValue).getData() : null;
    }

    public static ValueHolder get() {
        return holder.get();
    }

    public static void clear() {
        holder.remove();
    }
}

