/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.discovery;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public final class UnionDiscoveryClient
implements DiscoveryClient,
SmartInitializingSingleton,
DisposableBean {
    private final ObjectProvider<DiscoveryClient> discoveryClientsProvider;
    private List<DiscoveryClient> discoveryClients;

    public UnionDiscoveryClient(ObjectProvider<DiscoveryClient> discoveryClientsProvider) {
        this.discoveryClientsProvider = discoveryClientsProvider;
    }

    public String description() {
        return "Union Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        LinkedList<ServiceInstance> serviceInstances = new LinkedList<ServiceInstance>();
        List<DiscoveryClient> discoveryClients = this.getDiscoveryClients();
        for (DiscoveryClient discoveryClient : discoveryClients) {
            List instances = discoveryClient.getInstances(serviceId);
            if (instances == null || instances.isEmpty()) continue;
            serviceInstances.addAll(instances);
        }
        return serviceInstances;
    }

    public List<String> getServices() {
        LinkedHashSet services = new LinkedHashSet();
        List<DiscoveryClient> discoveryClients = this.getDiscoveryClients();
        for (DiscoveryClient discoveryClient : discoveryClients) {
            List serviceForClient = discoveryClient.getServices();
            if (serviceForClient == null) continue;
            services.addAll(serviceForClient);
        }
        return new ArrayList<String>(services);
    }

    public List<DiscoveryClient> getDiscoveryClients() {
        List<DiscoveryClient> discoveryClients = this.discoveryClients;
        if (discoveryClients != null) {
            return discoveryClients;
        }
        discoveryClients = new LinkedList<DiscoveryClient>();
        for (DiscoveryClient discoveryClient : this.discoveryClientsProvider) {
            String className = ClassUtils.getName((Object)discoveryClient);
            if ("org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClient".equals(className) || this.equals(discoveryClient)) continue;
            discoveryClients.add(discoveryClient);
        }
        return discoveryClients;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void afterSingletonsInstantiated() {
        this.discoveryClients = this.getDiscoveryClients();
    }

    public void destroy() throws Exception {
        this.discoveryClients.clear();
    }
}

