/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.discovery.autoconfigure;

import io.microsphere.spring.cloud.client.discovery.UnionDiscoveryClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"org.springframework.cloud.client.discovery.DiscoveryClient"})
@ConditionalOnDiscoveryEnabled
@ConditionalOnBlockingDiscoveryEnabled
@AutoConfigureBefore(name={"org.springframework.cloud.client.CommonsClientAutoConfiguration"})
public class DiscoveryClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="microsphere.spring.cloud.client.discovery", name={"mode"}, havingValue="union")
    public static class UnionConfiguration {
        @Bean
        public UnionDiscoveryClient unionDiscoveryClient(ObjectProvider<DiscoveryClient> discoveryClientsProvider) {
            return new UnionDiscoveryClient(discoveryClientsProvider);
        }
    }
}

