/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.event;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.context.ApplicationEvent;

public class ServiceInstancesChangedEvent
extends ApplicationEvent {
    private final List<ServiceInstance> serviceInstances;
    private boolean processed = false;

    public ServiceInstancesChangedEvent(String serviceName, List<ServiceInstance> serviceInstances) {
        super((Object)serviceName);
        this.serviceInstances = Collections.unmodifiableList(serviceInstances);
    }

    public String getServiceName() {
        return (String)this.getSource();
    }

    public List<ServiceInstance> getServiceInstances() {
        return this.serviceInstances;
    }

    public void processed() {
        this.processed = true;
    }

    public boolean isProcessed() {
        return this.processed;
    }
}

