/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;

public class InMemoryServiceRegistry
implements ServiceRegistry {
    private static final String STATUS_KEY = "_status_";
    private final ConcurrentMap<String, Registration> storage = new ConcurrentHashMap<String, Registration>(1);

    public void register(Registration registration) {
        String id = registration.getInstanceId();
        this.storage.put(id, registration);
    }

    public void deregister(Registration registration) {
        String id = registration.getInstanceId();
        this.storage.remove(id, registration);
    }

    public void close() {
        this.storage.clear();
    }

    public void setStatus(Registration registration, String status) {
        Map<String, String> metadata = this.getMetadata(registration);
        if (metadata != null) {
            metadata.put(STATUS_KEY, status);
        }
    }

    public Object getStatus(Registration registration) {
        Map<String, String> metadata = this.getMetadata(registration);
        if (metadata != null) {
            return metadata.get(STATUS_KEY);
        }
        return null;
    }

    protected Map<String, String> getMetadata(Registration registration) {
        String id = registration.getInstanceId();
        Registration instance = (Registration)this.storage.get(id);
        if (this.storage != null) {
            return instance.getMetadata();
        }
        return null;
    }
}

