/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry;

import io.microsphere.spring.cloud.client.service.registry.RegistrationMetaData;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.util.CollectionUtils;

public class MultipleRegistration
implements Registration {
    private Map<Class<? extends Registration>, Registration> registrationMap = new HashMap<Class<? extends Registration>, Registration>();
    private Registration defaultRegistration;
    private final RegistrationMetaData metaData;

    public MultipleRegistration(Collection<Registration> registrations) {
        if (CollectionUtils.isEmpty(registrations)) {
            throw new IllegalArgumentException("registrations cannot be empty");
        }
        for (Registration registration : registrations) {
            Class<?> clazz = registration.getClass();
            this.registrationMap.put(clazz, registration);
            this.defaultRegistration = registration;
        }
        this.metaData = new RegistrationMetaData(registrations);
    }

    public String getServiceId() {
        return this.getDefaultRegistration().getServiceId();
    }

    public String getHost() {
        return this.getDefaultRegistration().getHost();
    }

    public int getPort() {
        return this.getDefaultRegistration().getPort();
    }

    public boolean isSecure() {
        return this.getDefaultRegistration().isSecure();
    }

    public URI getUri() {
        return this.getDefaultRegistration().getUri();
    }

    public Map<String, String> getMetadata() {
        return this.metaData;
    }

    public Registration getDefaultRegistration() {
        return this.defaultRegistration;
    }

    public <T extends Registration> T special(Class<T> specialClass) {
        if (specialClass.equals(Registration.class)) {
            return (T)this;
        }
        return (T)((Registration)this.registrationMap.getOrDefault(specialClass, null));
    }
}

