/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry;

import io.microsphere.spring.cloud.client.service.registry.MultipleRegistration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MultipleServiceRegistry
implements ServiceRegistry<MultipleRegistration> {
    private final Map<String, ServiceRegistry> registriesMap;
    private final Map<String, Class<? extends Registration>> beanNameToRegistrationTypesMap;
    private ServiceRegistry defaultServiceRegistry;
    private String defaultRegistrationBeanName;

    public MultipleServiceRegistry(Map<String, ServiceRegistry> registriesMap) {
        if (CollectionUtils.isEmpty(registriesMap)) {
            throw new IllegalArgumentException("service registry cannot be empty");
        }
        this.registriesMap = registriesMap;
        this.beanNameToRegistrationTypesMap = new HashMap<String, Class<? extends Registration>>(registriesMap.size());
        for (Map.Entry<String, ServiceRegistry> entry : registriesMap.entrySet()) {
            String beanName = entry.getKey();
            ServiceRegistry serviceRegistry = entry.getValue();
            Class<? extends Registration> registrationClass = MultipleServiceRegistry.getRegistrationClass(serviceRegistry.getClass(), entry.getValue());
            this.beanNameToRegistrationTypesMap.put(beanName, registrationClass);
            this.defaultServiceRegistry = serviceRegistry;
            this.defaultRegistrationBeanName = beanName;
        }
    }

    public void register(MultipleRegistration registration) {
        this.iterate(registration, (reg, registry) -> registry.register(reg));
    }

    public void deregister(MultipleRegistration registration) {
        this.iterate(registration, (reg, registry) -> registry.deregister(reg));
    }

    public void close() {
        this.iterate(ServiceRegistry::close);
    }

    public void setStatus(MultipleRegistration registration, String status) {
        this.iterate(registration, (reg, registry) -> registry.setStatus(reg, status));
    }

    private void iterate(MultipleRegistration registration, BiConsumer<Registration, ServiceRegistry> action) {
        this.registriesMap.forEach((beanName, registry) -> {
            Class<? extends Registration> registrationClass = this.beanNameToRegistrationTypesMap.get(beanName);
            Registration targetRegistration = registration.special(registrationClass);
            if (targetRegistration != null) {
                action.accept(targetRegistration, (ServiceRegistry)registry);
            }
        });
    }

    private void iterate(Consumer<ServiceRegistry> action) {
        this.registriesMap.values().forEach(action);
    }

    public <T> T getStatus(MultipleRegistration registration) {
        Class<? extends Registration> registrationClass = this.beanNameToRegistrationTypesMap.get(this.defaultRegistrationBeanName);
        Registration targetRegistration = registration.special(registrationClass);
        return (T)this.defaultServiceRegistry.getStatus(targetRegistration);
    }

    private static Class<? extends Registration> getRegistrationClass(Class<? extends ServiceRegistry> serviceRegistryClass, ServiceRegistry serviceRegistry) {
        Class registrationClass = ResolvableType.forClass(serviceRegistryClass).as(ServiceRegistry.class).getGeneric(new int[]{0}).resolve();
        if (Registration.class.equals((Object)registrationClass)) {
            ClassLoader classLoader = serviceRegistryClass.getClassLoader();
            List registrationClassNames = AopUtils.isAopProxy((Object)serviceRegistry) ? SpringFactoriesLoader.loadFactoryNames((Class)AopProxyUtils.ultimateTargetClass((Object)serviceRegistry), (ClassLoader)classLoader) : SpringFactoriesLoader.loadFactoryNames(serviceRegistryClass, (ClassLoader)classLoader);
            for (String registrationClassName : registrationClassNames) {
                registrationClass = ClassUtils.resolveClassName((String)registrationClassName, (ClassLoader)classLoader);
            }
        }
        return registrationClass;
    }
}

