/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.util.CollectionUtils;

public final class RegistrationMetaData
implements Map<String, String> {
    private final Map<String, String> applicationMetaData;
    private final Collection<Registration> registrations;
    private final Object lock = new Object();

    public RegistrationMetaData(Collection<Registration> registrations) {
        if (CollectionUtils.isEmpty(registrations)) {
            throw new IllegalArgumentException("registrations cannot be empty");
        }
        this.registrations = registrations;
        this.applicationMetaData = new ConcurrentHashMap<String, String>();
        for (Registration registration : registrations) {
            Map metaData = registration.getMetadata();
            if (CollectionUtils.isEmpty((Map)metaData)) continue;
            metaData.forEach((k, v) -> {
                if (k == null || v == null) {
                    return;
                }
                this.applicationMetaData.put((String)k, (String)v);
            });
        }
    }

    @Override
    public int size() {
        return this.applicationMetaData.size();
    }

    @Override
    public boolean isEmpty() {
        return this.applicationMetaData.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.applicationMetaData.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.applicationMetaData.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.applicationMetaData.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(String key, String value) {
        Object object = this.lock;
        synchronized (object) {
            this.registrations.forEach((? super T registration) -> registration.getMetadata().put(key, value));
        }
        return this.applicationMetaData.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String remove(Object key) {
        Object object = this.lock;
        synchronized (object) {
            this.registrations.forEach((? super T registration) -> registration.getMetadata().remove(key));
        }
        return this.applicationMetaData.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        Object object = this.lock;
        synchronized (object) {
            this.registrations.forEach((? super T registration) -> registration.getMetadata().putAll(m));
        }
        this.applicationMetaData.putAll(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.registrations.forEach((? super T registration) -> registration.getMetadata().clear());
        }
        this.applicationMetaData.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.applicationMetaData.keySet());
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(this.applicationMetaData.values());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.applicationMetaData.entrySet();
    }
}

