/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry.aspect;

import io.microsphere.spring.cloud.client.service.registry.MultipleServiceRegistry;
import io.microsphere.spring.cloud.client.service.registry.RegistrationCustomizer;
import io.microsphere.spring.cloud.client.service.registry.event.RegistrationDeregisteredEvent;
import io.microsphere.spring.cloud.client.service.registry.event.RegistrationPreDeregisteredEvent;
import io.microsphere.spring.cloud.client.service.registry.event.RegistrationPreRegisteredEvent;
import io.microsphere.spring.cloud.client.service.registry.event.RegistrationRegisteredEvent;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

@Aspect
public class EventPublishingRegistrationAspect
implements ApplicationContextAware {
    public static final String REGISTER_POINTCUT_EXPRESSION = "execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.register(*)) && target(registry) && args(registration)";
    public static final String DEREGISTER_POINTCUT_EXPRESSION = "execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.deregister(*)) && target(registry) && args(registration)";
    private ApplicationContext context;
    private ObjectProvider<RegistrationCustomizer> registrationCustomizers;

    @Before(value="execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.register(*)) && target(registry) && args(registration)", argNames="registry, registration")
    public void beforeRegister(ServiceRegistry registry, Registration registration) {
        if (registry.getClass().isAssignableFrom(MultipleServiceRegistry.class)) {
            return;
        }
        this.context.publishEvent((ApplicationEvent)new RegistrationPreRegisteredEvent((ServiceRegistry<Registration>)registry, registration));
        this.registrationCustomizers.forEach(customizer -> customizer.customize(registration));
    }

    @Before(value="execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.deregister(*)) && target(registry) && args(registration)", argNames="registry, registration")
    public void beforeDeregister(ServiceRegistry registry, Registration registration) {
        if (registry.getClass().isAssignableFrom(MultipleServiceRegistry.class)) {
            return;
        }
        this.context.publishEvent((ApplicationEvent)new RegistrationPreDeregisteredEvent((ServiceRegistry<Registration>)registry, registration));
    }

    @After(value="execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.register(*)) && target(registry) && args(registration)", argNames="registry, registration")
    public void afterRegister(ServiceRegistry registry, Registration registration) {
        if (registry.getClass().isAssignableFrom(MultipleServiceRegistry.class)) {
            return;
        }
        this.context.publishEvent((ApplicationEvent)new RegistrationRegisteredEvent((ServiceRegistry<Registration>)registry, registration));
    }

    @After(value="execution(* org.springframework.cloud.client.serviceregistry.ServiceRegistry.deregister(*)) && target(registry) && args(registration)", argNames="registry, registration")
    public void afterDeregister(ServiceRegistry registry, Registration registration) {
        if (registry.getClass().isAssignableFrom(MultipleServiceRegistry.class)) {
            return;
        }
        this.context.publishEvent((ApplicationEvent)new RegistrationDeregisteredEvent((ServiceRegistry<Registration>)registry, registration));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.registrationCustomizers = applicationContext.getBeanProvider(RegistrationCustomizer.class);
    }
}

