/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry.autoconfigure;

import io.microsphere.spring.cloud.client.service.registry.MultipleAutoServiceRegistration;
import io.microsphere.spring.cloud.client.service.registry.MultipleRegistration;
import io.microsphere.spring.cloud.client.service.registry.MultipleServiceRegistry;
import io.microsphere.spring.cloud.client.service.registry.aspect.EventPublishingRegistrationAspect;
import io.microsphere.spring.cloud.client.service.registry.condition.ConditionalOnAutoServiceRegistrationEnabled;
import io.microsphere.spring.cloud.client.service.registry.condition.ConditionalOnMultipleRegistrationEnabled;
import java.util.Collection;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAutoServiceRegistrationEnabled
@Import(value={EventPublishingRegistrationAspect.class, MultipleConfiguration.class})
public class ServiceRegistryAutoConfiguration {

    @ConditionalOnMultipleRegistrationEnabled
    static class MultipleConfiguration {
        MultipleConfiguration() {
        }

        @Primary
        @Bean
        @ConditionalOnMissingBean
        public MultipleRegistration multipleRegistration(Collection<Registration> registrations) {
            return new MultipleRegistration(registrations);
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean
        public MultipleServiceRegistry multipleServiceRegistry(Map<String, ServiceRegistry> registriesMap) {
            return new MultipleServiceRegistry(registriesMap);
        }

        @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
        @Primary
        @Bean
        @ConditionalOnMissingBean
        public MultipleAutoServiceRegistration multipleAutoServiceRegistration(MultipleRegistration multipleRegistration, MultipleServiceRegistry multipleServiceRegistry, AutoServiceRegistrationProperties properties) {
            return new MultipleAutoServiceRegistration(multipleRegistration, multipleServiceRegistry, properties);
        }
    }
}

